mw.loader.implement("ext.uls.ime",function(){(function($,mw,document,undefined){'use strict';var mwImeRulesPath,inputSelector,inputPreferences,ulsIMEPreferences,customHelpLink;mwImeRulesPath=mw.config.get('wgExtensionAssetsPath')+'/UniversalLanguageSelector/lib/jquery.ime/';inputSelector='input:not([type]), input[type=text], input[type=search], textarea, [contenteditable]';inputPreferences=mw.uls.preferences();mw.ime=mw.ime||{};mw.ime.getLanguagesWithIME=function(){var language,ulsLanguages=mw.config.get('wgULSLanguages'),availableLanguages={};for(language in $.ime.languages){availableLanguages[language]=ulsLanguages[language];}return availableLanguages;};mw.ime.getIMELanguageList=function(){var unique=[],imeLanguageList,previousIMELanguages;previousIMELanguages=$.ime.preferences.getPreviousLanguages()||[];imeLanguageList=previousIMELanguages.concat(mw.uls.getFrequentLanguageList());$.each(imeLanguageList,function(i,v){if($.inArray(v,unique)===-1){unique.push(v);}});return unique.slice
(0,6);};ulsIMEPreferences={save:function(callback){if(!this.registry.isDirty){if(callback){callback.call(this,true);}return;}this.registry.isDirty=undefined;inputPreferences=mw.uls.preferences();inputPreferences.set('ime',this.registry);inputPreferences.save(callback);this.registry.isDirty=false;},load:function(){this.registry=inputPreferences.get('ime')||this.registry;},disable:function(){this.registry.isDirty=true;this.registry.enable=false;},enable:function(){this.registry.isDirty=true;this.registry.enable=true;},isEnabled:function(){if(this.registry.enable===undefined){return mw.config.get('wgULSIMEEnabled');}else{return this.registry.enable;}},getDefaultLanguage:function(){return mw.config.get('wgContentLanguage');}};customHelpLink=function(){var $disableInputToolsLink,$moreSettingsLink,imeselector=this;$disableInputToolsLink=$('<span>').addClass('uls-ime-disable-link').attr('data-i18n','ext-uls-input-disable');$moreSettingsLink=$('<span>').addClass('uls-ime-more-settings-link');
mw.loader.using(mw.uls.languageSettingsModules,function(){$moreSettingsLink.languagesettings({defaultModule:'input',onClose:function(){imeselector.$element.focus();},top:imeselector.$element.offset().top});});$moreSettingsLink.on('click',function(e){var languageSettings=$(this).data('languagesettings');imeselector.hide();if(!languageSettings){$(this).languagesettings({defaultModule:'input',onClose:function(){imeselector.$element.focus();},top:imeselector.$element.offset().top}).click();}e.stopPropagation();});$disableInputToolsLink.i18n();$disableInputToolsLink.on('click',function(e){$.ime.preferences.disable();imeselector.hide();imeselector.$imeSetting.hide();$.ime.preferences.save(function(){mw.ime.disable();imeNotification();mw.hook('mw.uls.ime.disable').fire('menu');});e.stopPropagation();});imeselector.$menu.webfonts();return $('<div>').addClass('uls-ime-menu-settings-item').append($disableInputToolsLink,$moreSettingsLink);};mw.ime.disable=function(){$(inputSelector).trigger(
'destroy.ime');};mw.ime.init=function(){if(!$.ime){return;}if($.ime.preferences.isEnabled){return;}$.extend($.ime.preferences,ulsIMEPreferences);$.extend($.ime.defaults,{imePath:mwImeRulesPath});$.ime.preferences.load();$.fn.imeselector.Constructor.prototype.helpLink=customHelpLink;$.fn.imeselector.Constructor.prototype.getAutonym=function(languageCode){return $.uls.data.getAutonym(languageCode);};};mw.ime.setup=function(){var imeSelectors=mw.config.get('wgULSImeSelectors').join(', ');mw.ime.init();$('body').on('focus.ime',imeSelectors,function(){mw.ime.handleFocus($(this));});};mw.ime.handleFocus=function($input){var noImeSelectors;if($input.is('.noime')||$input.data('ime')){return;}noImeSelectors=mw.config.get('wgULSNoImeSelectors').join(', ');if(noImeSelectors.length&&$input.is(noImeSelectors)){$input.addClass('noime');return;}if(!$.ime.preferences.isEnabled()){return;}if($input.is('[contenteditable]')&&!window.rangy){mw.loader.using('rangy.core',function(){mw.ime.addIme($input);});
return;}mw.ime.addIme($input);};mw.ime.addIme=function($input){var imeselector;$input.ime({languages:mw.ime.getIMELanguageList(),languageSelector:function(){var $ulsTrigger;$ulsTrigger=$('<a>').text('...').addClass('ime-selector-more-languages selectable-row selectable-row-item').attr({title:$.i18n('ext-uls-input-settings-more-languages-tooltip')});$ulsTrigger.uls({onSelect:function(language){$input.data('imeselector').selectLanguage(language);$input.focus();},languages:mw.ime.getLanguagesWithIME(),top:$input.offset().top});return $ulsTrigger;},helpHandler:function(ime){return $('<a>').attr({href:mw.msg('uls-ime-helppage').replace('$1',ime),target:'_blank',title:$.i18n('ext-uls-ime-help')}).addClass('ime-perime-help').click(function(event){event.stopPropagation();});}});imeselector=$input.data('imeselector');if(imeselector){imeselector.selectLanguage(imeselector.decideLanguage());imeselector.$element.on('setim.ime',function(event,inputMethod){mw.hook('mw.uls.ime.change').fire(
inputMethod);});}};function imeNotification(){var notificationMsg=(mw.config.get('wgULSPosition')==='personal')?'ext-uls-input-disable-notification-info-personal':'ext-uls-input-disable-notification-info-interlanguage',$notification=$('<div>').addClass('uls-ime-notification-bubble').append($('<div>').attr('data-i18n','ext-uls-input-disable-notification'),$('<div>').addClass('link').attr('data-i18n','ext-uls-input-disable-notification-undo').on('click',function(){$.ime.preferences.enable();$.ime.preferences.save(function(){mw.ime.setup();});}),$('<div>').attr('data-i18n',notificationMsg));mw.notify($notification.i18n());}}(jQuery,mediaWiki,document));;},{},{"uls-ime-helppage":"https://www.mediawiki.org/wiki/Special:MyLanguage/Help:Extension:UniversalLanguageSelector/Input_methods/$1"});mw.loader.implement("ext.uls.languagenames",function(){mw.config.set("wgULSLanguages",{"ab":"Abkhazian","ace":"Achinese","af":"Afrikaans","ak":"Akan","aln":"Gheg Albanian","am":"Amharic","an":"Aragonese",
"ang":"Old English","anp":"Angika","ar":"Arabic","arc":"Aramaic","arn":"Mapuche","ary":"Moroccan Spoken Arabic","arz":"Egyptian Spoken Arabic","as":"Assamese","ast":"Asturian","av":"Avaric","avk":"Kotava","ay":"Aymara","az":"Azerbaijani","azb":"South Azerbaijani","ba":"Bashkir","bar":"Bavarian","bbc":"Batak Toba","bbc-latn":"Batak Toba","bcc":"Southern Balochi","bcl":"Bikol Central","be":"Belarusian","be-tarask":"Belarusian (Taraškievica orthography)","bg":"Bulgarian","bh":"Bihari","bho":"Bhojpuri","bi":"Bislama","bjn":"Banjar","bm":"Bambara","bn":"Bengali","bo":"Tibetan","bpy":"Bishnupria Manipuri","bqi":"Bakhtiari","br":"Breton","brh":"Brahui","bs":"Bosnian","bug":"Buginese","bxr":"буряад","ca":"Catalan","cbk-zam":"Chavacano de Zamboanga","cdo":"Min Dong Chinese","ce":"Chechen","ceb":"Cebuano","ch":"Chamorro","chr":"Cherokee","ckb":"Sorani Kurdish","co":"Corsican","cps":"Capiznon","crh":"Crimean Turkish","crh-latn":"Crimean Turkish (Latin script)","crh-cyrl":
"Crimean Turkish (Cyrillic script)","cs":"Czech","csb":"Kashubian","cu":"Church Slavic","cv":"Chuvash","cy":"Welsh","da":"Danish","de":"German","de-at":"Austrian German","de-ch":"Swiss High German","de-formal":"German (formal address)","diq":"Zazaki","dsb":"Lower Sorbian","dtp":"Central Dusun","dv":"Divehi","dz":"Dzongkha","ee":"Ewe","egl":"Emiliàn","el":"Greek","eml":"Emiliano-Romagnolo","en":"English","en-ca":"Canadian English","en-gb":"British English","eo":"Esperanto","es":"Spanish","et":"Estonian","eu":"Basque","ext":"Extremaduran","fa":"Persian","ff":"Fulah","fi":"Finnish","fit":"meänkieli","fj":"Fijian","fo":"Faroese","fr":"French","frc":"Cajun French","frp":"Franco-Provençal","frr":"Northern Frisian","fur":"Friulian","fy":"Western Frisian","ga":"Irish","gag":"Gagauz","gan":"Gan","gan-hans":"Simplified Gan script","gan-hant":"Traditional Gan script","gd":"Scottish Gaelic","gl":"Galician","glk":"Gilaki","gn":"Guarani","gom-latn":"Goan Konkani (Latin script)","got":"Gothic",
"grc":"Ancient Greek","gsw":"Swiss German","gu":"Gujarati","gv":"Manx","ha":"Hausa","hak":"Hakka","haw":"Hawaiian","he":"Hebrew","hi":"Hindi","hif":"Fiji Hindi","hif-latn":"Fiji Hindi (Latin script)","hil":"Hiligaynon","hr":"Croatian","hsb":"Upper Sorbian","ht":"Haitian","hu":"Hungarian","hy":"Armenian","ia":"Interlingua","id":"Indonesian","ie":"Interlingue","ig":"Igbo","ii":"Sichuan Yi","ik":"Inupiaq","ike-cans":"Eastern Canadian (Aboriginal syllabics)","ike-latn":"Eastern Canadian (Latin script)","ilo":"Iloko","inh":"Ingush","io":"Ido","is":"Icelandic","it":"Italian","iu":"Inuktitut","ja":"Japanese","jam":"Jamaican Creole English","jbo":"Lojban","jut":"Jutish","jv":"Javanese","ka":"Georgian","kaa":"Kara-Kalpak","kab":"Kabyle","kbd":"Kabardian","kbd-cyrl":"Адыгэбзэ","kg":"Kongo","khw":"Khowar","kiu":"Kirmanjki","kk":"Kazakh","kk-arab":"Kazakh (Arabic script)","kk-cyrl":"Kazakh (Cyrillic script)","kk-latn":"Kazakh (Latin script)","kk-cn":"Kazakh (China)","kk-kz":
"Kazakh (Kazakhstan)","kk-tr":"Kazakh (Turkey)","kl":"Kalaallisut","km":"Khmer","kn":"Kannada","ko":"Korean","ko-kp":"한국어 (조선)","koi":"Komi-Permyak","krc":"Karachay-Balkar","kri":"Krio","krj":"Kinaray-a","ks":"Kashmiri","ks-arab":"Kashmiri (Arabic script)","ks-deva":"Kashmiri (Devanagari script)","ksh":"Colognian","ku":"Kurdish","ku-latn":"Kurdish (Latin script)","ku-arab":"كوردي (عەرەبی)‏","kv":"Komi","kw":"Cornish","ky":"Kyrgyz","la":"Latin","lad":"Ladino","lb":"Luxembourgish","lbe":"лакку","lez":"Lezghian","lfn":"Lingua Franca Nova","lg":"Ganda","li":"Limburgish","lij":"Ligure","liv":"Līvõ kēļ","lmo":"lumbaart","ln":"Lingala","lo":"Lao","lrc":"لوری","loz":"Lozi","lt":"Lithuanian","ltg":"Latgalian","lus":"Mizo","lv":"Latvian","lzh":"Literary Chinese","lzz":"Lazuri","mai":"Maithili","map-bms":"Basa Banyumasan","mdf":"Moksha","mg":"Malagasy","mhr":"Eastern Mari","mi":"Maori","min":"Minangkabau","mk":"Macedonian","ml":"Malayalam","mn":"Mongolian","mo"
:"Moldavian","mr":"Marathi","mrj":"Hill Mari","ms":"Malay","mt":"Maltese","mwl":"Mirandese","my":"Burmese","myv":"Erzya","mzn":"Mazanderani","na":"Nauru","nah":"Nahuatl","nan":"Min Nan Chinese","nap":"Neapolitan","nb":"Norwegian Bokmål","nds":"Low German","nds-nl":"Low Saxon (Netherlands)","ne":"Nepali","new":"Newari","niu":"Niuean","nl":"Dutch","nl-informal":"Nederlands (informeel)‎","nn":"Norwegian Nynorsk","nov":"Novial","nso":"Northern Sotho","nv":"Navajo","ny":"Nyanja","oc":"Occitan","om":"Oromo","or":"Oriya","os":"Ossetic","pa":"Punjabi","pag":"Pangasinan","pam":"Pampanga","pap":"Papiamento","pcd":"Picard","pdc":"Deitsch","pdt":"Plautdietsch","pfl":"Pälzisch","pi":"Pali","pih":"Norfuk / Pitkern","pl":"Polish","pms":"Piedmontese","pnb":"Western Punjabi","pnt":"Pontic","prg":"Prussian","ps":"Pashto","pt":"Portuguese","pt-br":"Brazilian Portuguese","qu":"Quechua","qug":"Runa shimi","rgn":"Romagnol","rif":"Tarifit","rm":"Romansh","rmy":"Romani","ro":"Romanian","roa-tara":
"tarandíne","ru":"Russian","rue":"Rusyn","rup":"Aromanian","ruq":"Megleno-Romanian","ruq-cyrl":"Megleno-Romanian (Cyrillic script)","ruq-latn":"Megleno-Romanian (Latin script)","sa":"Sanskrit","sah":"Sakha","sat":"Santali","sc":"Sardinian","scn":"Sicilian","sco":"Scots","sd":"Sindhi","sdc":"Sassaresu","se":"Northern Sami","sei":"Cmique Itom","sg":"Sango","sgs":"Samogitian","sh":"Serbo-Croatian","shi":"Tachelhit","si":"Sinhala","sk":"Slovak","sl":"Slovenian","sli":"Lower Silesian","sm":"Samoan","sma":"Southern Sami","sn":"Shona","so":"Somali","sq":"Albanian","sr":"Serbian","sr-ec":"Serbian (Cyrillic script)","sr-el":"Serbian (Latin script)","srn":"Sranan Tongo","ss":"Swati","st":"Southern Sotho","stq":"Seeltersk","su":"Sundanese","sv":"Swedish","sw":"Swahili","szl":"Silesian","ta":"Tamil","tcy":"Tulu","te":"Telugu","tet":"Tetum","tg":"Tajik","tg-cyrl":"Tajik (Cyrillic script)","tg-latn":"Tajik (Latin script)","th":"Thai","ti":"Tigrinya","tk":"Turkmen","tl":"Tagalog","tly":
"толышә зывон","tn":"Tswana","to":"Tongan","tokipona":"Toki Pona","tpi":"Tok Pisin","tr":"Turkish","tru":"Turoyo","ts":"Tsonga","tt":"Tatar","tt-cyrl":"Tatar (Cyrillic script)","tt-latn":"Tatar (Latin script)","ty":"Tahitian","tyv":"Tuvinian","udm":"Udmurt","ug":"Uyghur","ug-arab":"Uyghur (Arabic script)","ug-latn":"Uyghur (Latin script)","uk":"Ukrainian","ur":"Urdu","uz":"Uzbek","ve":"Venda","vec":"vèneto","vep":"Veps","vi":"Vietnamese","vls":"West-Vlams","vmf":"Upper Franconian","vo":"Volapük","vot":"Votic","vro":"Võro","wa":"Walloon","war":"Waray","wo":"Wolof","wuu":"Wu","xal":"Kalmyk","xh":"Xhosa","xmf":"Mingrelian","yi":"Yiddish","yo":"Yoruba","yue":"Cantonese","za":"Zhuang","zea":"Zeeuws","zh":"Chinese","zh-cn":"Chinese (China)","zh-hans":"Simplified Chinese","zh-hant":"Traditional Chinese","zh-hk":"Chinese (Hong Kong)","zh-mo":"中文（澳門）‎","zh-my":"中文（马来西亚）‎","zh-sg":"Chinese (Singapore)","zh-tw":"Chinese (Taiwan)","zu":"Zulu"});},{},{}
);mw.loader.implement("ext.uls.mediawiki",function(){(function($,mw){'use strict';$.fn.uls.defaults=$.extend($.fn.uls.defaults,{languages:mw.config.get('wgULSLanguages'),searchAPI:mw.util.wikiScript('api')+'?action=languagesearch'});$.fn.uls.Constructor.prototype.render=function(){this.$languageFilter.addClass('noime');};$.uls.data.addLanguage('als',{target:'gsw'});}(jQuery,mediaWiki));;},{},{});mw.loader.implement("jquery.ime",function(){(function($){'use strict';function IME(element,options){this.$element=$(element);$.ime.defaults.languages=arrayKeys($.ime.languages);this.options=$.extend({},$.ime.defaults,options);this.active=false;this.shifted=false;this.inputmethod=null;this.language=null;this.context='';this.selector=this.$element.imeselector(this.options);this.listen();}IME.prototype={constructor:IME,listen:function(){this.$element.on('keypress.ime',$.proxy(this.keypress,this));this.$element.on('keyup.ime',$.proxy(this.keyup,this));this.$element.on('keydown.ime',$.proxy(this.
keydown,this));this.$element.on('destroy.ime',$.proxy(this.destroy,this));this.$element.on('enable.ime',$.proxy(this.enable,this));this.$element.on('disable.ime',$.proxy(this.disable,this));},transliterate:function(input,context,altGr){var patterns,regex,rule,replacement,i,retval;if(altGr){patterns=this.inputmethod.patterns_x||[];}else{patterns=this.inputmethod.patterns||[];}if(this.shifted){patterns=(this.inputmethod.patterns_shift||[]).concat(patterns);}if($.isFunction(patterns)){retval=patterns.call(this,input,context);if(typeof retval==='string'){return{noop:input===retval,output:retval};}return retval;}for(i=0;i<patterns.length;i++){rule=patterns[i];regex=new RegExp(rule[0]+'$');replacement=rule.slice(-1)[0];if(regex.test(input)){if(rule.length===3){if(new RegExp(rule[1]+'$').test(context)){return{noop:false,output:input.replace(regex,replacement)};}}else{return{noop:false,output:input.replace(regex,replacement)};}}}return{noop:true,output:input};},keyup:function(e){if(e.which===
16){this.shifted=false;}},keydown:function(e){if(e.which===16){this.shifted=true;}},keypress:function(e){var altGr=false,c,startPos,pos,endPos,divergingPos,input,replacement;if(!this.active){return true;}if(!this.inputmethod){return true;}if(e.which===8){this.context='';return true;}if(e.altKey||e.altGraphKey){altGr=true;}if((e.which<32&&e.which!==13&&!altGr)||e.ctrlKey||e.metaKey){this.context='';return true;}c=String.fromCharCode(e.which);pos=this.getCaretPosition(this.$element);startPos=pos[0];endPos=pos[1];input=this.lastNChars(this.$element.val()||this.$element.text(),startPos,this.inputmethod.maxKeyLength);input+=c;replacement=this.transliterate(input,this.context,altGr);this.context+=c;if(this.context.length>this.inputmethod.contextLength){this.context=this.context.substring(this.context.length-this.inputmethod.contextLength);}if(replacement.noop){return true;}divergingPos=this.firstDivergence(input,replacement.output);input=input.substring(divergingPos);replacement.output=
replacement.output.substring(divergingPos);replaceText(this.$element,replacement.output,startPos-input.length+1,endPos);e.stopPropagation();return false;},isActive:function(){return this.active;},disable:function(){this.active=false;$.ime.preferences.setIM('system');},enable:function(){this.active=true;},toggle:function(){this.active=!this.active;},destroy:function(){$('body').off('.ime');this.$element.off('.ime').removeData('ime').removeData('imeselector');},getIM:function(){return this.inputmethod;},setIM:function(inputmethodId){this.inputmethod=$.ime.inputmethods[inputmethodId];$.ime.preferences.setIM(inputmethodId);},setLanguage:function(languageCode){if(!$.ime.languages[languageCode]){debug('Language '+languageCode+' is not known to jquery.ime.');return false;}this.language=languageCode;$.ime.preferences.setLanguage(languageCode);return true;},getLanguage:function(){return this.language;},load:function(inputmethodId){var ime=this,deferred=$.Deferred(),dependency;if($.ime.
inputmethods[inputmethodId]){return deferred.resolve();}dependency=$.ime.sources[inputmethodId].depends;if(dependency&&!$.ime.inputmethods[dependency]){ime.load(dependency).done(function(){ime.load(inputmethodId).done(function(){deferred.resolve();});});return deferred;}debug('Loading '+inputmethodId);deferred=$.getScript(ime.options.imePath+$.ime.sources[inputmethodId].source).done(function(){debug(inputmethodId+' loaded');}).fail(function(jqxhr,settings,exception){debug('Error in loading inputmethod '+inputmethodId+' Exception: '+exception);});return deferred.promise();},getCaretPosition:function($element){return getCaretPosition($element);},setCaretPosition:function($element,position){return setCaretPosition($element,position);},firstDivergence:function(a,b){return firstDivergence(a,b);},lastNChars:function(str,pos,n){return lastNChars(str,pos,n);}};$.fn.ime=function(option){return this.each(function(){var data,$this=$(this),options=typeof option==='object'&&option;if($this.prop(
'readonly')||$this.prop('disabled')||$this.hasClass('noime')){return;}data=$this.data('ime');if(!data){data=new IME(this,options);$this.data('ime',data);}if(typeof option==='string'){data[option]();}});};$.ime={};$.ime.inputmethods={};$.ime.sources={};$.ime.preferences={};$.ime.languages={};var defaultInputMethod={contextLength:0,maxKeyLength:1};$.ime.register=function(inputMethod){$.ime.inputmethods[inputMethod.id]=$.extend({},defaultInputMethod,inputMethod);};$.ime.defaults={imePath:'../',languages:[],helpHandler:null};function debug($obj){if(window.console&&window.console.log){window.console.log($obj);}}function getCaretPosition($element){var el=$element.get(0),start=0,end=0,normalizedValue,range,textInputRange,len,newLines,endRange;if($element.is('[contenteditable]')){return getDivCaretPosition(el);}if(typeof el.selectionStart==='number'&&typeof el.selectionEnd==='number'){start=el.selectionStart;end=el.selectionEnd;}else{range=document.selection.createRange();if(range&&range.
parentElement()===el){len=el.value.length;normalizedValue=el.value.replace(/\r\n/g,'\n');newLines=normalizedValue.match(/\n/g);textInputRange=el.createTextRange();textInputRange.moveToBookmark(range.getBookmark());endRange=el.createTextRange();endRange.collapse(false);if(textInputRange.compareEndPoints('StartToEnd',endRange)>-1){if(newLines){start=end=len-newLines.length;}else{start=end=len;}}else{start=-textInputRange.moveStart('character',-len);if(textInputRange.compareEndPoints('EndToEnd',endRange)>-1){end=len;}else{end=-textInputRange.moveEnd('character',-len);}}}}return[start,end];}function rangeForElementIE(element){var selection;if(element.nodeName.toLowerCase()==='input'){selection=element.createTextRange();}else{selection=document.body.createTextRange();selection.moveToElementText(element);}return selection;}function replaceText($element,replacement,start,end){var selection,length,newLines,scrollTop,range,correction,textNode,element=$element.get(0);if($element.is(
'[contenteditable]')){correction=setCaretPosition($element,{start:start,end:end});selection=rangy.getSelection();range=selection.getRangeAt(0);if(correction[0]>0){replacement=selection.toString().substring(0,correction[0])+replacement;}textNode=document.createTextNode(replacement);range.deleteContents();range.insertNode(textNode);range.commonAncestorContainer.normalize();start=end=start+replacement.length-correction[0];setCaretPosition($element,{start:start,end:end});return;}if(typeof element.selectionStart==='number'&&typeof element.selectionEnd==='number'){scrollTop=element.scrollTop;element.value=element.value.substring(0,start)+replacement+element.value.substring(end,element.value.length);element.scrollTop=scrollTop;element.selectionStart=element.selectionEnd=start+replacement.length;}else{selection=rangeForElementIE(element);length=element.value.length;newLines=element.value.match(/\n/g);if(newLines){length=length-newLines.length;}selection.moveStart('character',start);selection.
moveEnd('character',end-length);selection.text=replacement;selection.collapse(false);selection.select();}}function getDivCaretPosition(element){var charIndex=0,start=0,end=0,foundStart=false,foundEnd=false,sel=rangy.getSelection();function traverseTextNodes(node,range){var i,childNodesCount;if(node.nodeType===Node.TEXT_NODE){if(!foundStart&&node===range.startContainer){start=charIndex+range.startOffset;foundStart=true;}if(foundStart&&node===range.endContainer){end=charIndex+range.endOffset;foundEnd=true;}charIndex+=node.length;}else{childNodesCount=node.childNodes.length;for(i=0;i<childNodesCount;++i){traverseTextNodes(node.childNodes[i],range);if(foundEnd){break;}}}}if(sel.rangeCount){traverseTextNodes(element,sel.getRangeAt(0));}return[start,end];}function setCaretPosition($element,position){var currentPosition,startCorrection=0,endCorrection=0,element=$element[0];setDivCaretPosition(element,position);currentPosition=getDivCaretPosition(element);while(position.start!==currentPosition
[0]){position.start-=1;if(position.start<0){break;}setDivCaretPosition(element,position);currentPosition=getDivCaretPosition(element);startCorrection+=1;}while(position.end!==currentPosition[1]){position.end+=1;setDivCaretPosition(element,position);currentPosition=getDivCaretPosition(element);endCorrection+=1;if(endCorrection>10){break;}}return[startCorrection,endCorrection];}function setDivCaretPosition(element,position){var nextCharIndex,charIndex=0,range=rangy.createRange(),foundStart=false,foundEnd=false;range.collapseToPoint(element,0);function traverseTextNodes(node){var i,len;if(node.nodeType===3){nextCharIndex=charIndex+node.length;if(!foundStart&&position.start>=charIndex&&position.start<=nextCharIndex){range.setStart(node,position.start-charIndex);foundStart=true;}if(foundStart&&position.end>=charIndex&&position.end<=nextCharIndex){range.setEnd(node,position.end-charIndex);foundEnd=true;}charIndex=nextCharIndex;}else{for(i=0,len=node.childNodes.length;i<len;++i){
traverseTextNodes(node.childNodes[i]);if(foundEnd){rangy.getSelection().setSingleRange(range);break;}}}}traverseTextNodes(element);}function firstDivergence(a,b){var minLength,i;minLength=a.length<b.length?a.length:b.length;for(i=0;i<minLength;i++){if(a.charCodeAt(i)!==b.charCodeAt(i)){return i;}}return-1;}function lastNChars(str,pos,n){if(n===0){return'';}else if(pos<=n){return str.substr(0,pos);}else{return str.substr(pos-n,n);}}function arrayKeys(obj){return $.map(obj,function(element,index){return index;});}}(jQuery));(function($){'use strict';var selectorTemplate,MutationObserver;function IMESelector(element,options){this.$element=$(element);this.options=$.extend({},IMESelector.defaults,options);this.active=false;this.$imeSetting=null;this.$menu=null;this.inputmethod=null;this.timer=null;this.init();this.listen();}IMESelector.prototype={constructor:IMESelector,init:function(){this.prepareSelectorMenu();this.position();this.$imeSetting.hide();},prepareSelectorMenu:function(){this.
$imeSetting=$(selectorTemplate);this.$menu=$('<div class="imeselector-menu" role="menu">');this.$menu.append(imeListTitle(),imeList(),toggleMenuItem(),languageListTitle());this.prepareLanguageList();this.$menu.append(this.helpLink());if($.i18n){this.$menu.i18n();}this.$imeSetting.append(this.$menu);$('body').append(this.$imeSetting);},stopTimer:function(){if(this.timer){clearTimeout(this.timer);this.timer=null;}this.$imeSetting.stop(true,true);},resetTimer:function(){var imeselector=this;this.stopTimer();this.timer=setTimeout(function(){imeselector.$imeSetting.animate({'opacity':0,'marginTop':'-20px'},500,function(){imeselector.$imeSetting.hide();imeselector.$imeSetting.css('opacity',1);imeselector.$imeSetting.css('margin-top',0);});},this.options.timeout);},focus:function(){$('div.imeselector').hide();$('div.imeselector-menu').removeClass('ime-open');this.$imeSetting.show();this.resetTimer();},show:function(){this.$menu.addClass('ime-open');this.stopTimer();this.$imeSetting.show();
return false;},hide:function(){this.$menu.removeClass('ime-open');this.resetTimer();return false;},toggle:function(){if(this.$menu.hasClass('ime-open')){this.hide();}else{this.show();}},listen:function(){var imeselector=this;imeselector.$imeSetting.on('click.ime',function(e){var t=$(e.target);if(t.hasClass('imeselector-toggle')){imeselector.toggle();}return false;});imeselector.$element.on('blur.ime',function(){if(!imeselector.$imeSetting.hasClass('ime-onfocus')){imeselector.$imeSetting.hide();imeselector.hide();}});$('html').click(function(){imeselector.hide();});this.$menu.on('click',function(event){event.stopPropagation();});imeselector.$imeSetting.mouseenter(function(){imeselector.stopTimer();imeselector.$imeSetting.addClass('ime-onfocus');}).mouseleave(function(){imeselector.resetTimer();imeselector.$imeSetting.removeClass('ime-onfocus');});imeselector.$menu.on('click.ime','li',function(){imeselector.$element.focus();return false;});imeselector.$menu.on('click.ime','li.ime-im',
function(){imeselector.selectIM($(this).data('ime-inputmethod'));imeselector.$element.trigger('setim.ime',$(this).data('ime-inputmethod'));return false;});imeselector.$menu.on('click.ime','li.ime-lang',function(){var im=imeselector.selectLanguage($(this).attr('lang'));imeselector.$element.trigger('setim.ime',im);return false;});imeselector.$menu.on('click.ime','div.ime-disable',function(){imeselector.disableIM();return false;});imeselector.$menu.on('click.ime','.ime-help-link',function(e){e.stopPropagation();});imeselector.$element.on('focus.ime',function(e){imeselector.selectLanguage(imeselector.decideLanguage());imeselector.focus();e.stopPropagation();});imeselector.$element.attrchange(function(){if(imeselector.$element.is(':hidden')){imeselector.$imeSetting.hide();}});imeselector.$element.on('mouseup.ime',$.proxy(this.position,this));imeselector.$element.on('keydown.ime',$.proxy(this.keydown,this));$(window).resize(function(){imeselector.position();});},keydown:function(e){var ime=$
(e.target).data('ime'),firstInputmethod,previousInputMethods,languageCode;this.focus();if(isShortcutKey(e)){if(ime.isActive()){this.disableIM();this.$element.trigger('setim.ime','system');}else{if(this.inputmethod!==null){this.selectIM(this.inputmethod.id);this.$element.trigger('setim.ime',this.inputmethod.id);}else{languageCode=this.decideLanguage();this.selectLanguage(languageCode);if(!ime.isActive()&&$.ime.languages[languageCode]){previousInputMethods=$.ime.preferences.getPreviousInputMethods();if(previousInputMethods[0]){this.selectIM(previousInputMethods[0]);}else{firstInputmethod=$.ime.languages[languageCode].inputmethods[0];this.selectIM(firstInputmethod);}}}}e.preventDefault();e.stopPropagation();return false;}return true;},position:function(){var menuWidth,menuTop,menuLeft,elementPosition,top,left,verticalRoom,overflowsOnRight,imeSelector=this,rtlElement=this.$element.css('direction')==='rtl',$window=$(window);this.focus();elementPosition=this.$element.offset();top=
elementPosition.top+this.$element.outerHeight();left=elementPosition.left;if(!rtlElement){left=elementPosition.left+this.$element.outerWidth()-this.$imeSetting.outerWidth();}verticalRoom=$window.height()+$(document).scrollTop()-top;if(verticalRoom<this.$imeSetting.outerHeight()){top=elementPosition.top-this.$imeSetting.outerHeight();menuTop=this.$menu.outerHeight()+this.$imeSetting.outerHeight();if(menuTop<top){this.$menu.addClass('ime-position-top').css('top',-menuTop);}}this.$element.parents().each(function(){if($(this).css('position')==='fixed'){imeSelector.$imeSetting.css('position','fixed');return false;}});this.$imeSetting.css({top:top,left:left});menuWidth=this.$menu.width();overflowsOnRight=(left+menuWidth)>$window.width();if(menuWidth>left||rtlElement&&overflowsOnRight){if(rtlElement){if(overflowsOnRight){this.$menu.addClass('ime-right');menuLeft=this.$imeSetting.outerWidth()-menuWidth;}else{menuLeft=0;}}else{this.$menu.addClass('ime-right');menuLeft=elementPosition.left;}this
.$menu.css('left',menuLeft);}},selectLanguage:function(languageCode){var ime,imePref,language;languageCode=languageCode&&languageCode.toLowerCase();ime=this.$element.data('ime');imePref=$.ime.preferences.getIM(languageCode);language=$.ime.languages[languageCode];this.setMenuTitle(this.getAutonym(languageCode));if(!language){return false;}if(ime.getLanguage()===languageCode){if(ime.inputmethod&&ime.inputmethod.id!==imePref){this.selectIM($.ime.preferences.getIM(languageCode));}return $.ime.preferences.getIM(languageCode);}this.$menu.find('li.ime-lang').show();this.$menu.find('li[lang='+languageCode+']').hide();this.prepareInputMethods(languageCode);this.hide();ime.setLanguage(languageCode);this.inputmethod=null;this.selectIM($.ime.preferences.getIM(languageCode));return $.ime.preferences.getIM(languageCode);},getAutonym:function(languageCode){return $.ime.languages[languageCode].autonym;},setMenuTitle:function(title){this.$menu.find('.ime-list-title').text(title);},decideLanguage:
function(){if($.ime.preferences.getLanguage()){return $.ime.preferences.getLanguage();}if(this.$element.attr('lang')&&$.ime.languages[this.$element.attr('lang')]){return this.$element.attr('lang');}return $.ime.preferences.getDefaultLanguage();},selectIM:function(inputmethodId){var imeselector=this,ime;if(!inputmethodId){return;}this.$menu.find('.ime-checked').removeClass('ime-checked');this.$menu.find('li[data-ime-inputmethod='+inputmethodId+']').addClass('ime-checked');ime=this.$element.data('ime');if(inputmethodId==='system'){this.disableIM();return;}ime.load(inputmethodId).done(function(){imeselector.inputmethod=$.ime.inputmethods[inputmethodId];imeselector.hide();ime.enable();ime.setIM(inputmethodId);imeselector.$imeSetting.find('a.ime-name').text($.ime.sources[inputmethodId].name);imeselector.position();$.ime.preferences.save();});},disableIM:function(){this.$menu.find('.ime-checked').removeClass('ime-checked');this.$menu.find('div.ime-disable').addClass('ime-checked');this.
$element.data('ime').disable();this.$imeSetting.find('a.ime-name').text('');this.hide();this.position();$.ime.preferences.save();},prepareLanguageList:function(){var languageCodeIndex,$languageListWrapper,$languageList,languageList,$languageItem,$language,languageCode,language;$languageListWrapper=$('<div class="ime-language-list-wrapper">');$languageList=$('<ul class="ime-language-list">');if($.isFunction(this.options.languages)){languageList=this.options.languages();}else{languageList=this.options.languages;}for(languageCodeIndex in languageList){languageCode=languageList[languageCodeIndex];language=$.ime.languages[languageCode];if(!language){continue;}$languageItem=$('<a>').attr('href','#').text(this.getAutonym(languageCode)).addClass('selectable-row-item autonym');$language=$('<li class="ime-lang selectable-row">').attr('lang',languageCode);$language.append($languageItem);$languageList.append($language);}$languageListWrapper.append($languageList);this.$menu.append(
$languageListWrapper);if(this.options.languageSelector){this.$menu.append(this.options.languageSelector());}},prepareInputMethods:function(languageCode){var language=$.ime.languages[languageCode],$imeList=this.$menu.find('.ime-list'),imeSelector=this;$imeList.empty();$.each(language.inputmethods,function(index,inputmethod){var $imeItem,$inputMethod,source,name;source=$.ime.sources[inputmethod];if(!source){return;}name=source.name;$imeItem=$('<a>').attr('href','#').text(name).addClass('selectable-row-item');$inputMethod=$('<li>').attr('data-ime-inputmethod',inputmethod).addClass('ime-im selectable-row').append('<span class="ime-im-check"></span>',$imeItem);if(imeSelector.options.helpHandler){$inputMethod.append(imeSelector.options.helpHandler.call(imeSelector,inputmethod));}$imeList.append($inputMethod);});},helpLink:function(){return $('<div class="ime-help-link selectable-row">').append($('<a>').text('Help').addClass('selectable-row-item').attr({'href':
'http://github.com/wikimedia/jquery.ime','target':'_blank','data-i18n':'jquery-ime-help'}));}};IMESelector.defaults={defaultLanguage:'en',timeout:2500};$.fn.imeselector=function(options){return this.each(function(){var $this=$(this),data=$this.data('imeselector');if(!data){$this.data('imeselector',(data=new IMESelector(this,options)));}if(typeof options==='string'){data[options].call($this);}});};$.fn.imeselector.Constructor=IMESelector;function languageListTitle(){return $('<h3>').addClass('ime-lang-title').attr('data-i18n','jquery-ime-other-languages').text('Other languages');}function imeList(){return $('<ul>').addClass('ime-list');}function imeListTitle(){return $('<h3>').addClass('ime-list-title autonym');}function toggleMenuItem(){return $('<div class="ime-disable selectable-row">').append($('<span>').attr({'class':'ime-disable-link','data-i18n':'jquery-ime-disable-text'}).text('System input method'),$('<span>').addClass('ime-disable-shortcut').text('CTRL+M'));}selectorTemplate=
'<div class="imeselector imeselector-toggle">'+'<a class="ime-name imeselector-toggle" href="#"></a>'+'<b class="ime-setting-caret imeselector-toggle"></b></div>';MutationObserver=window.MutationObserver||window.WebKitMutationObserver||window.MozMutationObserver;function isShortcutKey(event){return event.ctrlKey&&!event.altKey&&(event.which===77||event.which===13);}function isDOMAttrModifiedSupported(){var p=document.createElement('p'),flag=false;if(p.addEventListener){p.addEventListener('DOMAttrModified',function(){flag=true;},false);}else if(p.attachEvent){p.attachEvent('onDOMAttrModified',function(){flag=true;});}else{return false;}p.setAttribute('id','target');return flag;}$.fn.attrchange=function(callback){if(MutationObserver){var observer;observer=new MutationObserver(function(mutations){mutations.forEach(function(e){callback.call(e.target,e.attributeName);});});return this.each(function(){observer.observe(this,{subtree:false,attributes:true});});}else if(
isDOMAttrModifiedSupported()){return this.on('DOMAttrModified',function(e){callback.call(this,e.attrName);});}else if('onpropertychange'in document.body){return this.on('propertychange',function(){callback.call(this,window.event.propertyName);});}};}(jQuery));(function($){'use strict';$.extend($.ime.preferences,{registry:{isDirty:false,language:null,previousLanguages:[],previousInputMethods:[],imes:{'en':'system'}},setLanguage:function(language){if(language===this.registry.language){return;}this.registry.language=language;this.registry.isDirty=true;if(!this.registry.previousLanguages){this.registry.previousLanguages=[];}if($.inArray(language,this.registry.previousLanguages)===-1){this.registry.previousLanguages.unshift(language);this.registry.previousLanguages=this.registry.previousLanguages.slice(0,5);}},getLanguage:function(){return this.registry.language;},getDefaultLanguage:function(){return'en';},getPreviousLanguages:function(){return this.registry.previousLanguages;},
getPreviousInputMethods:function(){return this.registry.previousInputMethods;},setIM:function(inputMethod){if(!this.registry.imes){this.registry.imes={};}if(inputMethod===this.registry.imes[this.registry.language]){return;}this.registry.imes[this.getLanguage()]=inputMethod;this.registry.isDirty=true;if(!this.registry.previousInputMethods){this.registry.previousInputMethods=[];}if(inputMethod!=='system'){this.registry.previousInputMethods.unshift(inputMethod);this.registry.previousInputMethods=this.registry.previousInputMethods.slice(0,5);}},getIM:function(language){if(!this.registry.imes){this.registry.imes={};}return this.registry.imes[language]||'system';},save:function(){},load:function(){}});}(jQuery));(function($){'use strict';$.extend($.ime.sources,{'am-transliteration':{name:'ትራንስልተራትዖን',source:'rules/am/am-transliteration.js'},'ar-kbd':{name:'أرابيك',source:'rules/ar/ar-kbd.js'},'as-avro':{name:'অভ্ৰ',source:'rules/as/as-avro.js'},'as-bornona':
{name:'বৰ্ণনা',source:'rules/as/as-bornona.js'},'as-inscript':{name:'ইনস্ক্ৰিপ্ট',source:'rules/as/as-inscript.js'},'as-inscript2':{name:'ইনস্ক্ৰিপ্ট ২',source:'rules/as/as-inscript2.js'},'as-phonetic':{name:'ফনেটিক',source:'rules/as/as-phonetic.js'},'as-transliteration':{name:'প্ৰতিৰূপান্তৰণ',source:'rules/as/as-transliteration.js'},'be-kbd':{name:'Стандартная',source:'rules/be/be-kbd.js'},'be-latin':{name:'Łacinka',source:'rules/be/be-latin.js'},'be-transliteration':{name:'Транслітэрацыя',source:'rules/be/be-transliteration.js'},'ber-tfng':{name:'Tifinagh',source:'rules/ber/ber-tfng.js'},'bn-avro':{name:'অভ্র',source:'rules/bn/bn-avro.js'},'bn-inscript':{name:'ইনস্ক্ৰিপ্ট',source:'rules/bn/bn-inscript.js'},'bn-inscript2':{name:'ইনস্ক্ৰিপ্ট ২',source:'rules/bn/bn-inscript2.js'},'bn-nkb':{name:
'ন্যাশনাল কিবোর্ড',source:'rules/bn/bn-nkb.js'},'bn-probhat':{name:'প্রভাত',source:'rules/bn/bn-probhat.js'},'brx-inscript':{name:'इनस्क्रिप्ट',source:'rules/brx/brx-inscript.js'},'brx-inscript2':{name:'इनस्क्रिप्ट २',source:'rules/brx/brx-inscript2.js'},'ckb-transliteration-arkbd':{name:'باشووری',source:'rules/ckb/ckb-transliteration-arkbd.js'},'ckb-transliteration-fakbd':{name:'ڕۆژھەڵاتی',source:'rules/ckb/ckb-transliteration-fakbd.js'},'ckb-transliteration-lakbd':{name:'لاتینی',source:'rules/ckb/ckb-transliteration-lakbd.js'},'cv-cyr-altgr':{name:'Чăвашла (AltGr)',source:'rules/cv/cv-cyr-altgr.js'},'cv-lat-altgr':{name:'Căvašla (AltGr)',source:'rules/cv/cv-lat-altgr.js'},'cv-cyr-numbers':{name:'Чăвашла (цифрилисем)',source:'rules/cv/cv-cyr-numbers.js'},'cyrl-palochka':{name:'Palochka',source:'rules/cyrl/cyrl-palochka.js'},'da-normforms':{name:
'normalformer',source:'rules/da/da-normforms.js'},'doi-inscript2':{name:'इनस्क्रिप्ट २',source:'rules/doi/doi-inscript2.js'},'eo-transliteration':{name:'transliterigo',source:'rules/eo/eo-transliteration.js'},'eo-h':{name:'Esperanto h',source:'rules/eo/eo-h.js'},'eo-h-f':{name:'Esperanto h fundamente',source:'rules/eo/eo-h-f.js'},'eo-plena':{name:'Esperanto plena',source:'rules/eo/eo-plena.js'},'eo-q':{name:'Esperanto q sistemo',source:'rules/eo/eo-q.js'},'eo-vi':{name:'Esperanto vi sistemo',source:'rules/eo/eo-vi.js'},'eo-x':{name:'Esperanto x sistemo',source:'rules/eo/eo-x.js'},'fa-kbd':{name:'فارسی',source:'rules/fa/fa-kbd.js'},'fo-normforms':{name:'Føroyskt',source:'rules/fo/fo-normforms.js'},'fi-transliteration':{name:'translitterointi',source:'rules/fi/fi-transliteration.js'},'hi-transliteration':{name:'लिप्यंतरण',source:'rules/hi/hi-transliteration.js'},'hi-inscript':{name:'इनस्क्रिप्ट',source:
'rules/hi/hi-inscript.js'},'hi-inscript2':{name:'इनस्क्रिप्ट २',source:'rules/hi/hi-inscript2.js'},'hi-phonetic':{name:'फोनेटिक',source:'rules/hi/hi-phonetic.js'},'is-normforms':{name:'Venjuleg eyðublöð',source:'rules/is/is-normforms.js'},'jv-transliteration':{name:'Transliteration',source:'rules/jv/jv-transliteration.js'},'mai-inscript':{name:'इनस्क्रिप्ट',source:'rules/mai/mai-inscript.js',depends:'hi-inscript'},'mai-inscript2':{name:'इनस्क्रिप्ट २',source:'rules/mai/mai-inscript2.js',depends:'hi-inscript2'},'hi-bolnagri':{name:'बोलनागरी',source:'rules/hi/hi-bolnagri.js'},'ml-transliteration':{name:'ലിപ്യന്തരണം',source:'rules/ml/ml-transliteration.js'},'ml-inscript':{name:'ഇൻസ്ക്രിപ്റ്റ്',source:'rules/ml/ml-inscript.js'},'ml-inscript2':{name:'ഇൻസ്ക്രിപ്റ്റ് 2',source:'rules/ml/ml-inscript2.js'},
'sv-normforms':{name:'Normal forms',source:'rules/sv/sv-normforms.js'},'ta-inscript':{name:'இன்ஸ்கிரிப்ட்',source:'rules/ta/ta-inscript.js'},'ta-inscript2':{name:'இன்ஸ்கிரிப்ட் 2',source:'rules/ta/ta-inscript2.js'},'ta-transliteration':{name:'எழுத்துப்பெயர்ப்பு',source:'rules/ta/ta-transliteration.js'},'ta-99':{name:'தமிழ்99',source:'rules/ta/ta-99.js'},'ta-bamini':{name:'பாமினி',source:'rules/ta/ta-bamini.js'},'th-kedmanee':{name:'เกษมณี',source:'rules/th/th-kedmanee.js'},'th-pattachote':{name:'ปัตตะโชติ',source:'rules/th/th-pattachote.js'},'de-transliteration':{name:'Deutsch Tilde',source:'rules/de/de-transliteration.js'},'el-kbd':{name:'Τυπική πληκτρολόγιο',source:'rules/el/el-kbd.js'},'he-standard-2012':{name:'עברית עם ניקוד על בסיס אנגלית',source:'rules/he/he-standard-2012.js'},
'he-standard-2012-extonly':{name:'עברית עם ניקוד',source:'rules/he/he-standard-2012-extonly.js'},'hr-kbd':{name:'Croatian kbd',source:'rules/hr/hr-kbd.js'},'hy-ephonetic':{name:'Հնչյունային դասավորություն',source:'rules/hy/hy-ephonetic.js'},'hy-typewriter':{name:'Գրամեքենայի դասավորություն',source:'rules/hy/hy-typewriter.js'},'hy-ephoneticalt':{name:'Հնչյունային նոր (R→Ր, F→Թ)',source:'rules/hy/hy-ephoneticalt.js'},'hy-emslegacy':{name:'Մայքրոսոֆթի հին արևելահայերեն',source:'rules/hy/hy-emslegacy.js'},'hy-wmslegacy':{name:'Մայքրոսոֆթի հին արևմտահայերեն',source:'rules/hy/hy-wmslegacy.js'},'gu-inscript':{name:'ઇનસ્ક્રિપ્ટ',source:'rules/gu/gu-inscript.js'},'gu-inscript2':{name:'ઇનસ્ક્રિપ્ટ ૨',source:'rules/gu/gu-inscript2.js'},'gu-phonetic':{name:'ફોનૅટિક',source:'rules/gu/gu-phonetic.js'},
'gu-transliteration':{name:'લિપ્યાંતરણ',source:'rules/gu/gu-transliteration.js'},'ka-transliteration':{name:'ტრანსლიტერაცია',source:'rules/ka/ka-transliteration.js'},'ka-kbd':{name:'სტანდარტული კლავიატურის',source:'rules/ka/ka-kbd.js'},'kk-arabic':{name:'Kazakh Arabic transliteration',source:'rules/kk/kk-arabic.js'},'kk-kbd':{name:'Кирил',source:'rules/kk/kk-kbd.js'},'kn-inscript':{name:'ಇನ್ಸ್ಕ್ರಿಪ್ಟ್',source:'rules/kn/kn-inscript.js'},'kn-inscript2':{name:'ಇನ್\u200cಸ್ಕ್ರಿಪ್ಟ್ ೨',source:'rules/kn/kn-inscript2.js'},'kn-transliteration':{name:'ಲಿಪ್ಯಂತರಣ',source:'rules/kn/kn-transliteration.js'},'kn-kgp':{name:'KGP/Nudi/KP Rao',source:'rules/kn/kn-kgp.js'},'ky-cyrl-alt':{name:'Кыргыз Alt',source:'rules/ky/ky-cyrl-alt.js'},'gom-inscript2':{name:'इनस्क्रिप्ट २',source:
'rules/gom/gom-inscript2.js'},'ks-inscript':{name:'इनस्क्रिप्ट',source:'rules/ks/ks-inscript.js'},'ks-kbd':{name:'Kashmiri Arabic',source:'rules/ks/ks-kbd.js'},'ku-h':{name:'Kurdî-h',source:'rules/ku/ku-h.js'},'ku-tr':{name:'Kurdî-tr',source:'rules/ku/ku-tr.js'},'lo-kbd':{name:'າຶກ',source:'rules/lo/lo-kbd.js'},'mh':{name:'Kajin M̧ajeļ',source:'rules/mh/mh.js'},'mn-cyrl':{name:'Кирилл',source:'rules/mn/mn-cyrl.js'},'mni-inscript2':{name:'ইনস্ক্ৰিপ্ট ২',source:'rules/mni/mni-inscript2.js'},'mr-inscript':{name:'मराठी लिपी',source:'rules/mr/mr-inscript.js'},'mr-inscript2':{name:'मराठी इनस्क्रिप्ट २',source:'rules/mr/mr-inscript2.js'},'mr-transliteration':{name:'अक्षरांतरण',source:'rules/mr/mr-transliteration.js'},'mr-phonetic':{name:'फोनेटिक',source:'rules/mr/mr-phonetic.js'},'my-xkb':{name:'မြန်မာဘာသာ xkb',source:
'rules/my/my-xkb.js'},'ne-inscript':{name:'इनस्क्रिप्ट',source:'rules/ne/ne-inscript.js'},'ne-inscript2':{name:'इनस्क्रिप्ट २',source:'rules/ne/ne-inscript2.js'},'ne-transliteration':{name:'ट्रांस्लितेरेशन',source:'rules/ne/ne-transliteration.js'},'ne-rom':{name:'Romanized',source:'rules/ne/ne-rom.js'},'ne-trad':{name:'Traditional',source:'rules/ne/ne-trad.js'},'nb-normforms':{name:'Normal transliterasjon',source:'rules/nb/nb-normforms.js'},'nb-tildeforms':{name:'Tildemerket transliterasjon',source:'rules/nb/nb-tildeforms.js'},'nn-tildeforms':{name:'Tildemerkt transliterasjon',source:'rules/nb/nb-tildeforms.js'},'or-transliteration':{name:'ଟ୍ରାନ୍ସଲିଟରେସନ',source:'rules/or/or-transliteration.js'},'or-inscript':{name:'ଇନସ୍କ୍ରିପ୍ଟ',source:'rules/or/or-inscript.js'},'or-inscript2':{name:'ଇନସ୍କ୍ରିପ୍ଟ2',source:'rules/or/or-inscript2.js'},
'or-lekhani':{name:'ଲେଖନୀ',source:'rules/or/or-lekhani.js'},'or-phonetic':{name:'ଫୋନେଟିକ',source:'rules/or/or-phonetic.js'},'sd-inscript2':{name:'इनस्क्रिप्ट २',source:'rules/sd/sd-inscript2.js'},'se-normforms':{name:'Normal forms',source:'rules/se/se-normforms.js'},'sk-kbd':{name:'Štandardná',source:'rules/sk/sk-kbd.js'},'sr-kbd':{name:'Стандардна',source:'rules/sr/sr-kbd.js'},'te-inscript':{name:'ఇన్\u200dస్క్రిప్ట్',source:'rules/te/te-inscript.js'},'te-inscript2':{name:'ఇన్\u200dస్క్రిప్ట్ 2',source:'rules/te/te-inscript2.js'},'te-transliteration':{name:'లిప్యంతరీకరణ',source:'rules/te/te-transliteration.js'},'pa-inscript':{name:'ਇਨਸ੍ਕ੍ਰਿਪ੍ਟ',source:'rules/pa/pa-inscript.js'},'pa-inscript2':{name:'ਇਨਸ੍ਕ੍ਰਿਪ੍ਟ2',source:'rules/pa/pa-inscript2.js'},'pa-jhelum':{name:'ਜੇਹਲਮ',source:
'rules/pa/pa-jhelum.js'},'pa-transliteration':{name:'ਤ੍ਰਾਨ੍ਸ੍ਲਿਤੇਰਾਤਿਓਂ',source:'rules/pa/pa-transliteration.js'},'pa-phonetic':{name:'ਫੋਨੇਟਿਕ',source:'rules/pa/pa-phonetic.js'},'ru-jcuken':{name:'ЙЦУКЕН',source:'rules/ru/ru-jcuken.js'},'ru-kbd':{name:'кбд',source:'rules/ru/ru-kbd.js'},'ru-phonetic':{name:'фонетический',source:'rules/ru/ru-phonetic.js'},'ru-yawerty':{name:'yawerty',source:'rules/ru/ru-yawerty.js'},'sa-iast':{name:'Romanized',source:'rules/sa/sa-iast.js'},'sa-inscript':{name:'इनस्क्रिप्ट',source:'rules/sa/sa-inscript.js'},'sa-inscript2':{name:'इनस्क्रिप्ट २',source:'rules/sa/sa-inscript2.js'},'sa-transliteration':{name:'ट्रन्स्लितेरतिओन्',source:'rules/sa/sa-transliteration.js'},'sah-transliteration':{name:'Transliteration',source:'rules/sah/sah-transliteration.js'},'sat-inscript2':{name:
'इनस्क्रिप्ट २',source:'rules/sat/sat-inscript2.js'},'si-singlish':{name:'සිංග්ලිෂ්',source:'rules/si/si-singlish.js'},'si-wijesekara':{name:'විජේසේකර',source:'rules/si/si-wijesekara.js'},'ur-phonetic':{name:'صوتی',source:'rules/ur/ur-phonetic.js'},'ur-transliteration':{name:'ٹرانسلٹریشن',source:'rules/ur/ur-transliteration.js'},'ipa-sil':{name:'International Phonetic Alphabet - SIL',source:'rules/fonipa/ipa-sil.js'},'ipa-x-sampa':{name:'International Phonetic Alphabet - X-SAMPA',source:'rules/fonipa/ipa-x-sampa.js'},'udm-alt':{name:'Удмурт ALT',source:'rules/udm/udm-alt.js'},'uk-kbd':{name:'кбд',source:'rules/uk/uk-kbd.js'},'ug-kbd':{name:'Uyghur kbd',source:'rules/ug/ug-kbd.js'},'uz-kbd':{name:'Uzbek kbd',source:'rules/uz/uz-kbd.js'}});$.extend($.ime.languages,{'ady':{autonym:'адыгэбзэ',inputmethods:['cyrl-palochka']},'ahr':{autonym:'अहिराणी',inputmethods:['mr-transliteration',
'mr-inscript']},'am':{autonym:'አማርኛ',inputmethods:['am-transliteration']},'ar':{autonym:'العربية',inputmethods:['ar-kbd']},'as':{autonym:'অসমীয়া',inputmethods:['as-transliteration','as-avro','as-bornona','as-inscript','as-phonetic','as-inscript2']},'av':{autonym:'авар',inputmethods:['cyrl-palochka']},'be':{autonym:'беларуская',inputmethods:['be-transliteration','be-latin','be-kbd']},'be-tarask':{autonym:'беларуская (тарашкевіца)',inputmethods:['be-transliteration','be-latin']},'bh':{autonym:'भोजपुरी',inputmethods:['hi-transliteration']},'bho':{autonym:'भोजपुरी',inputmethods:['hi-transliteration']},'bn':{autonym:'বাংলা',inputmethods:['bn-avro','bn-inscript','bn-nkb','bn-probhat','bn-inscript2']},'brx':{autonym:'बोड़ो',inputmethods:['brx-inscript','brx-inscript2']},'ckb':{autonym:'کوردی',inputmethods:['ckb-transliteration-arkbd','ckb-transliteration-fakbd',
'ckb-transliteration-lakbd']},'ce':{autonym:'нохчийн',inputmethods:['cyrl-palochka']},'cv':{autonym:'Чăвашла',inputmethods:['cv-cyr-altgr','cv-lat-altgr','cv-cyr-numbers']},'da':{autonym:'Dansk',inputmethods:['da-normforms']},'de':{autonym:'Deutsch',inputmethods:['de-transliteration']},'diq':{autonym:'Kirdkî',inputmethods:['ku-h','ku-tr']},'doi':{autonym:'डोगरी',inputmethods:['doi-inscript2']},'en':{autonym:'English',inputmethods:['ipa-sil','ipa-x-sampa']},'el':{autonym:'Ελληνικά',inputmethods:['el-kbd']},'eo':{autonym:'Esperanto',inputmethods:['eo-transliteration','eo-h','eo-h-f','eo-plena','eo-q','eo-vi','eo-x']},'fa':{autonym:'فارسی',inputmethods:['fa-kbd']},'fo':{autonym:'Føroyskt',inputmethods:['fo-normforms']},'fi':{autonym:'Suomi',inputmethods:['fi-transliteration']},'gom':{autonym:'कोंकणी',inputmethods:['hi-transliteration','hi-inscript','gom-inscript2']},'gu':{autonym:'ગુજરાતી',inputmethods:['gu-transliteration',
'gu-inscript','gu-inscript2','gu-phonetic']},'he':{autonym:'עברית',inputmethods:['he-standard-2012-extonly','he-standard-2012']},'hi':{autonym:'हिन्दी',inputmethods:['hi-transliteration','hi-inscript','hi-bolnagri','hi-phonetic','hi-inscript2']},'hr':{autonym:'Hrvatski',inputmethods:['hr-kbd']},'hy':{autonym:'հայերեն',inputmethods:['hy-ephonetic','hy-typewriter','hy-ephoneticalt','hy-emslegacy','hy-wmslegacy']},'hne':{autonym:'छत्तीसगढ़ी',inputmethods:['hi-transliteration']},'is':{autonym:'Íslenska',inputmethods:['is-normforms']},'fonipa':{autonym:'International Phonetic Alphabet',inputmethods:['ipa-sil','ipa-x-sampa']},'jv':{autonym:'ꦧꦱꦗꦮ',inputmethods:['jv-transliteration']},'ka':{autonym:'ქართული ენა',inputmethods:['ka-transliteration','ka-kbd']},'kbd':{autonym:'адыгэбзэ (къэбэрдеибзэ)',inputmethods:['cyrl-palochka']},'kk':{autonym:'Қазақша',inputmethods:['kk-kbd','kk-arabic']},'kn':{
autonym:'ಕನ್ನಡ',inputmethods:['kn-transliteration','kn-inscript','kn-kgp','kn-inscript2']},'ks':{autonym:'कॉशुर / کٲشُر',inputmethods:['ks-inscript','ks-kbd']},'ky':{autonym:'Кыргыз',inputmethods:['ky-cyrl-alt']},'kab':{autonym:'ⵜⴰⵇⴱⴰⵢⵍⵉⵜ',inputmethods:['ber-tfng']},'ku':{autonym:'Kurdî',inputmethods:['ku-h','ku-tr']},'lbe':{autonym:'лакку',inputmethods:['cyrl-palochka']},'lez':{autonym:'лезги',inputmethods:['cyrl-palochka']},'lo':{autonym:'ລາວ',inputmethods:['lo-kbd']},'mai':{autonym:'मैथिली',inputmethods:['mai-inscript','mai-inscript2']},'mh':{autonym:'Kajin M̧ajeļ',inputmethods:['mh']},'ml':{autonym:'മലയാളം',inputmethods:['ml-transliteration','ml-inscript','ml-inscript2']},'mn':{autonym:'Монгол',inputmethods:['mn-cyrl']},'mni':{autonym:'Manipuri',inputmethods:['mni-inscript2']},'mr':{autonym:'मराठी',inputmethods:['mr-transliteration','mr-inscript2','mr-inscript','mr-phonetic']
},'my':{autonym:'မြန်မာ',inputmethods:['my-xkb']},'ne':{autonym:'नेपाली',inputmethods:['ne-transliteration','ne-inscript2','ne-inscript','ne-rom','ne-trad']},'new':{autonym:'नेपाल भाषा',inputmethods:['hi-transliteration','hi-inscript']},'nb':{autonym:'Norsk (bokmål)',inputmethods:['nb-normforms','nb-tildeforms']},'nn':{autonym:'Norsk (nynorsk)',inputmethods:['nb-normforms','nn-tildeforms']},'or':{autonym:'ଓଡ଼ିଆ',inputmethods:['or-phonetic','or-transliteration','or-inscript','or-inscript2','or-lekhani']},'pa':{autonym:'ਪੰਜਾਬੀ',inputmethods:['pa-transliteration','pa-inscript','pa-phonetic','pa-inscript2','pa-jhelum']},'rif':{autonym:'ⵜⴰⵔⵉⴼⵉⵜ',inputmethods:['ber-tfng']},'ru':{autonym:'русский',inputmethods:['ru-jcuken','ru-kbd','ru-phonetic','ru-yawerty']},'sah':{autonym:'саха тыла',inputmethods:['sah-transliteration']},'sa':{autonym:'संस्कृत',inputmethods:['sa-transliteration',
'sa-inscript2','sa-inscript','sa-iast']},'sat':{autonym:'संताली',inputmethods:['sat-inscript2']},'sd':{autonym:'सिंधी',inputmethods:['sd-inscript2']},'se':{autonym:'Davvisámegiella',inputmethods:['se-normforms']},'shi':{autonym:'ⵜⴰⵛⵍⵃⵉⵜ',inputmethods:['ber-tfng']},'si':{autonym:'සිංහල',inputmethods:['si-singlish','si-wijesekara']},'sk':{autonym:'Slovenčina',inputmethods:['sk-kbd']},'sr':{autonym:'Српски / srpski',inputmethods:['sr-kbd']},'sv':{autonym:'Svenska',inputmethods:['sv-normforms']},'ta':{autonym:'தமிழ்',inputmethods:['ta-transliteration','ta-99','ta-inscript','ta-bamini','ta-inscript2']},'tcy':{autonym:'ತುಳು',inputmethods:['kn-transliteration']},'te':{autonym:'తెలుగు',inputmethods:['te-transliteration','te-inscript','te-inscript2']},'th':{autonym:'ไทย',inputmethods:['th-kedmanee','th-pattachote']},'tkr':{autonym:'цӀаӀхна миз',inputmethods:['cyrl-palochka']},'tzm':{autonym:
'ⵜⴰⵎⴰⵣⵉⵖⵜ',inputmethods:['ber-tfng']},'udm':{autonym:'удмурт',inputmethods:['udm-alt']},'uk':{autonym:'Українська',inputmethods:['uk-kbd']},'ug':{autonym:'ئۇيغۇرچە / Uyghurche',inputmethods:['ug-kbd']},'ur':{autonym:'اردو',inputmethods:['ur-transliteration','ur-phonetic']},'uz':{autonym:'Oʻzbekcha',inputmethods:['uz-kbd']}});}(jQuery));;},{"css":[
".imeselector{position:absolute;background:url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAA8AAAALCAQAAAAKTh/XAAAAAnNCSVQICFXsRgQAAAAJcEhZcwAABnYAAAZ2ASkmb4AAAAAZdEVYdFNvZnR3YXJlAHd3dy5pbmtzY2FwZS5vcmeb7jwaAAAAvklEQVQYV2P4z/CfIVQ0rCqsKrQibHWEIYiPgGAibE2YXbhphFW4GqokUDpsBhA+BpNYIEPYf3wQJN0PhItDq8O2h6eHng5NCLsEwaGnwdKhRaFFYd1hkWFLIhzC9oZbhB6F4LC9EN3/gYy9YefD1oU9DFsQ9hqIn4cvDbsBM/x/uGe4Z1hlqGLYSqAnDwHxzlDOsIlw6bDfQPgn7GfYv7AfQN4PIP0z7C9C+nWoBzoEWgKX/hf+AB0CTQDKAABdtqyW/bSH4AAAAABJRU5ErkJggg==) no-repeat left center;background:url(//bits.wikimedia.org/static-1.23wmf10/extensions/UniversalLanguageSelector/lib/jquery.ime/css/../images/ime-active.png?2014-01-09T16:51:40Z) no-repeat left center!ie;background-image:-webkit-linear-gradient(transparent,transparent),url(data:image/svg+xml;base64,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);background-image:-webkit-linear-gradient(transparent,transparent),url(//bits.wikimedia.org/static-1.23wmf10/extensions/UniversalLanguageSelector/lib/jquery.ime/css/../images/ime-active.svg?2014-01-09T16:51:40Z)!ie;background-image:-moz-linear-gradient(transparent,transparent),url(data:image/svg+xml;base64,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);background-image:-moz-linear-gradient(transparent,transparent),url(//bits.wikimedia.org/static-1.23wmf10/extensions/UniversalLanguageSelector/lib/jquery.ime/css/../images/ime-active.svg?2014-01-09T16:51:40Z)!ie;background-image:linear-gradient(transparent,transparent),url(data:image/svg+xml;base64,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);background-image:linear-gradient(transparent,transparent),url(//bits.wikimedia.org/static-1.23wmf10/extensions/UniversalLanguageSelector/lib/jquery.ime/css/../images/ime-active.svg?2014-01-09T16:51:40Z)!ie;background-color:rgba(255,255,255,0.75);background-position:left 3px center;background-position-x:3px;height:15px;font-size:small;padding:2px 2px 1px 20px;box-shadow:0 1px 3px 0 #777;margin-top:0;text-align:left;font-family:sans-serif;white-space:nowrap;z-index:1000}.imeselector:hover{box-shadow:0 1px 3px 0 #565656;border-top:none;background-color:rgba(255,255,255,0.85)}.imeselector a,.ime-disable{cursor:pointer;text-decoration:none;outline:none;color:#222222;line-height:1em;padding-top:4px;padding-bottom:4px}.ime-setting-caret{margin-left:2px;margin-top:8px;border-left:4px solid transparent;border-right:4px solid transparent;border-top:4px solid #565656;content:\"\";display:inline-block;height:0;vertical-align:top;width:0}span.ime-disable-link{padding-left:20px;white-space:nowrap}span.ime-disable-shortcut{text-align:right;margin-left:10px;color:#888;font-size:smaller;padding-right:4px}.ime-list-title,.ime-lang-title{color:#39d;border-bottom:solid 1px #39d;text-align:left;font-size:larger;font-weight:normal;padding-bottom:5px;padding-left:20px;padding-top:9px;margin:0 0 1px}.ime-language-list-wrapper{position:relative;padding:0;display:block;overflow-y:auto;max-height:150px}.imeselector-menu{position:absolute;top:14px;right:0;z-index:1000;display:none;float:left;margin-top:13px;min-width:160px;padding:0;border:1px solid #888;background-color:#FFFFFF;-webkit-border-radius:5px;-moz-border-radius:5px;border-radius:5px;-webkit-box-shadow:0 5px 10px rgba(0,0,0,0.2);-moz-box-shadow:0 5px 10px rgba(0,0,0,0.2);box-shadow:0 5px 10px rgba(0,0,0,0.2);-webkit-background-clip:padding-box;-moz-background-clip:padding;background-clip:padding-box;text-align:left}.imeselector-menu.ime-right{right:auto}.imeselector-menu ul{width:100%;padding:0;margin:0;list-style:none} .imeselector-menu:before{border-bottom:7px solid #888;border-left:7px solid transparent;border-right:7px solid transparent;content:\"\";display:inline-block;right:9px;position:absolute;top:-7px}.imeselector-menu.ime-right:before{right:auto;left:9px}.imeselector-menu:after{border-bottom:6px solid #FFFFFF;border-left:6px solid transparent;border-right:6px solid transparent;content:\"\";display:inline-block;right:10px;position:absolute;top:-6px}.imeselector-menu.ime-right:after{right:auto;left:10px}.imeselector-menu.ime-position-top:before{border-bottom:0 none;border-top:7px solid #888;top:auto;bottom:-7px}.imeselector-menu.ime-position-top:after{border-bottom:0 none;border-top:6px solid #FFFFFF;top:auto;bottom:-6px}.imeselector-menu .ime-checked{background:url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAwAAAAJCAQAAACssQXfAAAAAnNCSVQICFXsRgQAAAAJcEhZcwAABikAAAYpAendlDkAAAAZdEVYdFNvZnR3YXJlAHd3dy5pbmtzY2FwZS5vcmeb7jwaAAAAhElEQVQIW2P4z4AOtXmUtik7YQgrCCidUPqvvBFNWE1E6bzSf6UtChxAjgMLTFheUukqUHitMet/BgblcKXLatIgYSU5pdtA4aUQhQzKi4Cce2pKyipKD4GseQxMEN0MDExKc4ACz4Dwv9JUBkaYsSDEqDgRKPhfqRfZGVBKuVW5BdV9ACkeW2BshrvTAAAAAElFTkSuQmCC) no-repeat left center;background:url(//bits.wikimedia.org/static-1.23wmf10/extensions/UniversalLanguageSelector/lib/jquery.ime/css/../images/tick.png?2014-01-09T16:51:40Z) no-repeat left center!ie;background-image:-webkit-linear-gradient(transparent,transparent),url(data:image/svg+xml;base64,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);background-image:-webkit-linear-gradient(transparent,transparent),url(//bits.wikimedia.org/static-1.23wmf10/extensions/UniversalLanguageSelector/lib/jquery.ime/css/../images/tick.svg?2014-01-09T16:51:40Z)!ie;background-image:-moz-linear-gradient(transparent,transparent),url(data:image/svg+xml;base64,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);background-image:-moz-linear-gradient(transparent,transparent),url(//bits.wikimedia.org/static-1.23wmf10/extensions/UniversalLanguageSelector/lib/jquery.ime/css/../images/tick.svg?2014-01-09T16:51:40Z)!ie;background-image:linear-gradient(transparent,transparent),url(data:image/svg+xml;base64,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);background-image:linear-gradient(transparent,transparent),url(//bits.wikimedia.org/static-1.23wmf10/extensions/UniversalLanguageSelector/lib/jquery.ime/css/../images/tick.svg?2014-01-09T16:51:40Z)!ie;background-position:left 4px center;background-position-x:4px}.imeselector-menu .ime-help-link{background-color:#f0f0f0;border-radius:0 0 5px 5px;border-top:1px solid #ddd;margin-top:6px;padding:2px 0;color:#444}.imeselector-menu .ime-help-link \u003E a:hover{background-color:#f0f0f0;color:#000}.imeselector-menu .selectable-row-item{display:block;padding-left:20px;padding-right:20px;font-weight:normal;color:#333333;outline:none;white-space:nowrap;position:relative}.imeselector-menu .selectable-row{cursor:pointer}.imeselector-menu .selectable-row:hover{background-color:#f0f0f0}.ime-open{*z-index:1000;display:block}.imeselector-menu li{position:relative}\n/* cache key: enwiki:resourceloader:filter:minify-css:7:6db2f6792fe776c786253803dbcf6d73 */"
]},{});mw.loader.implement("jquery.uls",function(){(function($){'use strict';var template,ULS;template=
'\
		<div class="grid uls-menu uls-wide"> \
			<div class="row"> \
				<span id="uls-close" class="icon-close"></span> \
			</div> \
			<div class="row"> \
				<div class="uls-title-region seven columns">\
					<h1 data-i18n="uls-select-language" class="uls-title">Select Language</h1>\
				</div>\
				<div class="five columns map-block" id="map-block">\
					<div class="row">\
						<div data-regiongroup="1" id="uls-region-1" class="three columns uls-region uls-region-1">\
							<a data-i18n="uls-region-WW">Worldwide</a>\
						</div>\
						<div class="nine columns">\
							<div class="row uls-worldmap">\
								<div data-regiongroup="2" id="uls-region-2" class="four columns uls-region">\
									<a data-i18n="uls-region-AM">America</a>\
								</div>\
								<div data-regiongroup="3" id="uls-region-3" class="four columns uls-region">\
									<a><span data-i18n="uls-region-EU">Europe</span><br>\
									<span data-i18n="uls-region-ME">Middle East</span><br>\
									<span data-i18n="uls-region-AF">Africa</span></a>\
								</div>\
								<div data-regiongroup="4" id="uls-region-4" class="four columns uls-region">\
									<a><span data-i18n="uls-region-AS">Asia</span><br>\
									<span data-i18n="uls-region-PA">Pacific</span></a>\
								</div>\
							</div>\
						</div>\
					</div>\
				</div>\
			</div>\
			<div id="search" class="row search"> \
				<div class="one column">\
					<span class="search-label"></span>\
				</div>\
				<div class="ten columns">\
					<div id="search-input-block" class="search-input-block">\
						<input type="text" class="filterinput filtersuggestion" id="filtersuggestion" disabled="true"\
							autocomplete="off" /> <input type="text" class="filterinput languagefilter" id="languagefilter"\
							data-clear="languagefilter-clear" data-suggestion="filtersuggestion"\
							placeholder="Language search" autocomplete="off" />\
					</div>\
				</div>\
				<div class="one column">\
					<span id="languagefilter-clear" class="languagefilter-clear"></span>\
				</div>\
			</div>\
			<div class="row uls-language-list"></div>\
			<div class="row" id="settings-block"></div>\
		</div> '
;ULS=function(element,options){this.$element=$(element);this.options=$.extend({},$.fn.uls.defaults,options);this.$menu=$(template);this.languages=this.options.languages;for(var code in this.languages){if($.uls.data.languages[code]===undefined){delete this.languages[code];}}this.left=this.options.left;this.top=this.options.top;this.shown=false;this.initialized=false;this.$languageFilter=this.$menu.find('#languagefilter');this.$regionFilters=this.$menu.find('.uls-region');this.$resultsView=this.$menu.find('div.uls-language-list');this.render();this.listen();this.ready();};ULS.prototype={constructor:ULS,ready:function(){if(this.options.onReady){this.options.onReady.call(this);}},visible:function(){if(this.options.onVisible){this.options.onVisible.call(this);}},position:function(){var pos=$.extend({},this.$element.offset(),{height:this.$element[0].offsetHeight});return{top:this.top||pos.top+pos.height,left:this.left||'25%'};},show:function(){this.$menu.css(this.position());if(this.options.
compact){this.$menu.addClass('uls-compact');}if(!this.initialized){$('body').prepend(this.$menu);this.i18n();this.defaultSearch();this.initialized=true;}$('.uls-menu').hide();this.$menu.show();this.$menu.scrollIntoView();this.shown=true;if(!this.isMobile()){this.$languageFilter.focus();}this.visible();},i18n:function(){if($.i18n){this.$menu.find('[data-i18n]').i18n();this.$languageFilter.prop('placeholder',$.i18n('uls-search-placeholder'));}},defaultSearch:function(){this.$resultsView.lcd('empty');this.$regionFilters.regionselector('show');},hide:function(){this.$menu.hide();this.shown=false;},render:function(){},noresults:function(){$('.regionselector').removeClass('active');this.$resultsView.lcd('noResults');},success:function(){$('.regionselector').removeClass('active');this.$resultsView.show();},listen:function(){var lcd,uls=this;uls.$element.on('click',$.proxy(uls.click,uls));uls.$languageFilter.on('searchclear.uls',$.proxy(uls.defaultSearch,uls));uls.$languageFilter.on(
'noresults.uls',$.proxy(uls.noresults,uls));uls.$languageFilter.on('resultsfound.uls',$.proxy(uls.success,uls));uls.$menu.find('#uls-close').on('click',$.proxy(uls.cancel,uls));uls.$menu.on('click',function(e){e.stopPropagation();});uls.$menu.on('keypress',$.proxy(this.keypress,this)).on('keyup',$.proxy(this.keyup,this));if(this.eventSupported('keydown')){this.$menu.on('keydown',$.proxy(this.keypress,this));}lcd=uls.$resultsView.lcd({languages:uls.languages,quickList:uls.options.quickList,clickhandler:$.proxy(uls.select,uls),source:uls.$languageFilter,showRegions:uls.options.showRegions}).data('lcd');uls.$languageFilter.languagefilter({$target:lcd,languages:uls.languages,searchAPI:uls.options.searchAPI,onSelect:$.proxy(uls.select,uls)});this.$menu.find('.uls-region, .uls-region-link').regionselector({$target:lcd,languages:uls.languages,success:function(regionfilter){uls.$languageFilter.languagefilter('deactivate');if(regionfilter.regionGroup===1){lcd.quicklist();}uls.success();},
noresults:function(){uls.$languageFilter.languagefilter('clear');}});$('html').click($.proxy(this.hide,this));},select:function(langCode){this.hide();this.$languageFilter.trigger('searchclear');if(this.options.onSelect){this.options.onSelect.call(this,langCode);}},cancel:function(){this.hide();if(this.options.onCancel){this.options.onCancel.call(this);}},keyup:function(e){if(!this.shown){return;}if(e.keyCode===27){this.cancel();e.preventDefault();e.stopPropagation();}},keypress:function(e){if(!this.shown){return;}if(e.keyCode===27){this.cancel();e.preventDefault();e.stopPropagation();}},click:function(e){e.stopPropagation();e.preventDefault();if(this.shown){this.hide();}else{this.show();}},eventSupported:function(eventName){var isSupported=eventName in this.$menu;if(!isSupported){this.$element.setAttribute(eventName,'return;');isSupported=typeof this.$element[eventName]==='function';}return isSupported;},isMobile:function(){return navigator.userAgent.match(
/(iPhone|iPod|iPad|Android|BlackBerry)/);}};$.fn.uls=function(option){return this.each(function(){var $this=$(this),data=$this.data('uls'),options=typeof option==='object'&&option;if(!data){$this.data('uls',(data=new ULS(this,options)));}if(typeof option==='string'){data[option]();}});};$.fn.uls.defaults={menu:template,onSelect:null,searchAPI:null,languages:$.uls.data.getAutonyms(),quickList:null,compact:false,showRegions:['WW','AM','EU','ME','AF','AS','PA']};if(!$.fn.i18n){$.fn.i18n=function(){};}$.fn.scrollIntoView=function(){return this.each(function(){var scrollPosition,$window=$(window),windowHeight=$window.height(),windowTop=$window.scrollTop(),windowBottom=windowTop+windowHeight,$element=$(this),panelHeight=$element.height(),panelTop=$element.offset().top,panelBottom=panelTop+panelHeight;if((panelTop<windowTop)||(panelBottom>windowBottom)){if(windowTop>panelTop){scrollPosition=panelTop;}else{scrollPosition=panelBottom-windowHeight;}$('html, body').stop().animate({scrollTop:
scrollPosition},500);}});};$.fn.uls.Constructor=ULS;}(jQuery));(function($){'use strict';var noResultsTemplate,LanguageCategoryDisplay;noResultsTemplate=
'\
	<div class="twelve columns uls-no-results-view hide">\
		<h2 data-i18n="uls-no-results-found" class="eleven columns offset-by-one uls-no-results-found-title">\
		No results found\
		</h2>\
		<div id="uls-no-found-more" class="uls-no-found-more">\
			<div class="ten columns offset-by-one">\
				<p>\
					<span data-i18n="uls-search-help">You can search by language name, \
					script name, ISO code of language or \
					you can browse by region:</span>\
					<a class="uls-region-link" data-i18n="uls-region-AM" data-region="AM">America</a>, \
					<a class="uls-region-link" data-i18n="uls-region-EU" data-region="EU">Europe</a>, \
					<a class="uls-region-link" data-i18n="uls-region-ME" data-region="ME">Middle East</a>, \
					<a class="uls-region-link" data-i18n="uls-region-AF" data-region="AF">Africa</a>, \
					<a class="uls-region-link" data-i18n="uls-region-AS" data-region="AS">Asia</a>, \
					<a class="uls-region-link" data-i18n="uls-region-PA" data-region="PA">Pacific</a>, \
					<a class="uls-region-link" data-i18n="uls-region-WW" data-region="WW">Worldwide</a>.\
				</p>\
			</div>\
		</div>\
	</div>'
;LanguageCategoryDisplay=function(element,options){this.$element=$(element);this.options=$.extend({},$.fn.lcd.defaults,options);this.$element.addClass('lcd');this.regionLanguages={};this.renderTimeout=null;this.cachedQuicklist=null;this.$element.append($(noResultsTemplate));this.$noResults=this.$element.children('.uls-no-results-view');this.render();this.listen();};LanguageCategoryDisplay.prototype={constructor:LanguageCategoryDisplay,append:function(langCode,regionCode){var lcd=this,i,regions;if(!this.options.languages[langCode]){return false;}if(regionCode){regions=[regionCode];}else{regions=$.uls.data.getRegions(langCode);}if($.inArray('WW',regions)>-1){regions=['WW'];}for(i=0;i<regions.length;i++){this.regionLanguages[regions[i]].push(langCode);}window.clearTimeout(this.renderTimeout);this.renderTimeout=window.setTimeout(function(){lcd.renderRegions();},50);return true;},render:function(){var $section,lcd=this,regions=[],regionNames={WW:'Worldwide',SP:'Special',AM:'America',EU:
'Europe',ME:'Middle East',AS:'Asia',AF:'Africa',PA:'Pacific'};regions.push(this.buildQuicklist());$.each($.uls.data.regiongroups,function(regionCode){lcd.regionLanguages[regionCode]=[];if($.inArray(regionCode,lcd.options.showRegions)===-1){return;}$section=$('<div>').addClass('eleven columns offset-by-one uls-lcd-region-section hide').attr('id',regionCode).append($('<h3>').attr('data-i18n','uls-region-'+regionCode).addClass('eleven columns uls-lcd-region-title').text(regionNames[regionCode]));regions.push($section);});lcd.$element.append(regions);this.i18n();},renderRegions:function(){var lcd=this,languages,items=lcd.options.itemsPerColumn,columns=4;this.$noResults.addClass('hide');this.$element.find('.uls-lcd-region-section').each(function(){var $region=$(this),regionCode=$region.attr('id');if($region.is('#uls-lcd-quicklist')){return;}$region.children('.uls-language-block').remove();languages=lcd.regionLanguages[regionCode];if(!languages||languages.length===0){$region.addClass('hide')
;return;}lcd.renderRegion($region,languages,items,columns);$region.removeClass('hide');lcd.regionLanguages[regionCode]=[];});},renderRegion:function($region,languages,itemsPerColumn,columnsPerRow){var i,lastItem,currentScript,nextScript,force,len=languages.length,items=[],columns=[],rows=[];for(i=0;i<len;i++){force=false;nextScript=$.uls.data.getScriptGroupOfLanguage(languages[i+1]);lastItem=len-i===1;if(i===0){currentScript=$.uls.data.getScriptGroupOfLanguage(languages[i]);}else if(currentScript!==nextScript&&items.length>1){force=true;}currentScript=nextScript;items.push(this.renderItem(languages[i]));if(items.length>=itemsPerColumn||lastItem||force){columns.push($('<ul>').addClass('three columns').append(items));items=[];if(columns.length>=columnsPerRow||lastItem){rows.push($('<div>').addClass('row uls-language-block').append(columns));columns=[];}}}$region.append(rows);},renderItem:function(code){var a,name,autonym,li;name=this.options.languages[code];autonym=$.uls.data.getAutonym(
code)||name||code;li=document.createElement('li');li.title=name;li.lang=code;li.dir=$.uls.data.getDir(code);li.setAttribute('data-code',code);a=document.createElement('a');a.appendChild(document.createTextNode(autonym));a.className='autonym';li.appendChild(a);return li;},i18n:function(){this.$element.find('[data-i18n]').i18n();},quicklist:function(){this.$element.find('#uls-lcd-quicklist').removeClass('hide');},buildQuicklist:function(){var quickList,$quickListSection,$quickListSectionTitle;if(this.cachedQuicklist!==null){return this.cachedQuicklist;}if($.isFunction(this.options.quickList)){this.options.quickList=this.options.quickList();}if(!this.options.quickList){this.cachedQuicklist=$([]);return this.cachedQuicklist;}quickList=this.options.quickList;quickList=quickList.slice(0,16);quickList.sort($.uls.data.sortByAutonym);$quickListSection=$('<div>').addClass('eleven columns offset-by-one uls-lcd-region-section').attr('id','uls-lcd-quicklist');$quickListSectionTitle=$('<h3>').attr(
'data-i18n','uls-common-languages').addClass('eleven columns uls-lcd-region-title').text('Common languages');$quickListSection.append($quickListSectionTitle);this.renderRegion($quickListSection,quickList,4,4);$quickListSectionTitle.i18n();this.cachedQuicklist=$quickListSection;return this.cachedQuicklist;},show:function(){if(!this.regionDivs){this.render();}},empty:function(){this.$element.find('#uls-lcd-quicklist').addClass('hide');},focus:function(){this.$element.focus();},noResults:function(){this.$noResults.removeClass('hide');if(this.$noResults.find('.uls-lcd-region-title').length){return;}var $suggestions=this.buildQuicklist().clone();$suggestions.find('h3').data('i18n','uls-no-results-suggestion-title').text('You may be interested in:').i18n();this.$noResults.find('h2').after($suggestions);},listen:function(){var lcd=this;if(this.options.clickhandler){this.$element.on('click','.row li',function(){lcd.options.clickhandler.call(this,$(this).data('code'));});}lcd.$element.scroll(
function(){var inview,inviewRegion,$ulsLanguageList=$(this),scrollTop=$ulsLanguageList.position().top,scrollBottom=$ulsLanguageList.height();inviewRegion='WW';lcd.$element.find('.uls-lcd-region-section').each(function(){var $lcdRegionSection=$(this),top=$lcdRegionSection.position().top,height=$lcdRegionSection.height(),padding=10;if(top-padding<=scrollTop&&height>scrollBottom){inviewRegion=$lcdRegionSection.attr('id');}});inview=$.uls.data.regiongroups[inviewRegion];if(!$('#uls-region-'+inview).hasClass('active')){$('.regionselector').removeClass('active');$('#uls-region-'+inview).addClass('active');}});}};$.fn.lcd=function(option){return this.each(function(){var $this=$(this),data=$this.data('lcd'),options=typeof option==='object'&&option;if(!data){$this.data('lcd',(data=new LanguageCategoryDisplay(this,options)));}if(typeof option==='string'){data[option]();}});};$.fn.lcd.defaults={languages:null,showRegions:['WW','AM','EU','ME','AF','AS','PA'],itemsPerColumn:8};$.fn.lcd.Constructor=
LanguageCategoryDisplay;}(jQuery));(function($){'use strict';var LanguageFilter,delay;LanguageFilter=function(element,options){this.$element=$(element);this.options=$.extend({},$.fn.regionselector.defaults,options);this.$element.addClass('languagefilter');this.resultCount=0;this.$suggestion=this.$element.parents().find('#'+this.$element.data('suggestion'));this.$clear=this.$element.parents().find('#'+this.$element.data('clear'));this.selectedLanguage=null;this.listen();};delay=(function(){var timer=0;return function(callback,milliseconds){clearTimeout(timer);timer=setTimeout(callback,milliseconds);};}());LanguageFilter.prototype={listen:function(){this.$element.on('keypress',$.proxy(this.keyup,this)).on('keyup',$.proxy(this.keyup,this));if(this.eventSupported('keydown')){this.$element.on('keydown',$.proxy(this.keyup,this));}if(this.$clear.length){this.$clear.on('click',$.proxy(this.clear,this));}this.toggleClear();},keyup:function(e){var suggestion,query,languageFilter;switch(e.keyCode
){case 9:suggestion=this.$suggestion.val();if(suggestion&&suggestion!==this.$element.val()){this.$element.val(suggestion);e.preventDefault();e.stopPropagation();}break;case 13:if(!this.options.onSelect){break;}e.preventDefault();e.stopPropagation();query=$.trim(this.$element.val()).toLowerCase();if(this.selectedLanguage){this.options.onSelect(this.selectedLanguage);}else if(this.options.languages[query]){this.options.onSelect(query);}break;default:languageFilter=this;if(e.which<32&&e.which!==8){break;}this.selectedLanguage=null;delay(function(){if(!languageFilter.$element.val()){languageFilter.clear();}else{languageFilter.options.$target.empty();languageFilter.search();}},300);this.toggleClear();}},deactivate:function(){this.$element.val('');if(!$.fn.uls.Constructor.prototype.isMobile()){this.$element.focus();}this.toggleClear();this.autofill();},clear:function(){this.deactivate();this.$element.trigger('searchclear.uls');},toggleClear:function(){if(!this.$clear.length){return;}if(this.
$element.val()){this.$clear.show();}else{this.$clear.hide();}},search:function(){var languagesInScript,query=$.trim(this.$element.val()),languages=$.uls.data.getLanguagesByScriptGroup(this.options.languages),scriptGroup,langNum,langCode;this.resultCount=0;for(scriptGroup in languages){languagesInScript=languages[scriptGroup];languagesInScript.sort($.uls.data.sortByAutonym);for(langNum=0;langNum<languagesInScript.length;langNum++){langCode=languagesInScript[langNum];if(query===''||this.filter(langCode,query)){if(this.resultCount===0){this.autofill(langCode);}if(query.toLowerCase()===langCode){this.selectedLanguage=langCode;}if(this.render(langCode)){this.resultCount++;}}}}if(!this.resultCount&&this.options.searchAPI&&query){this.searchAPI(query);}else{this.resultHandler(query);}},searchAPI:function(query){var languageFilter=this;$.get(languageFilter.options.searchAPI,{search:query},function(result){$.each(result.languagesearch,function(code,name){if(languageFilter.resultCount===0){
languageFilter.autofill(code,name);}if(languageFilter.render(code)){languageFilter.resultCount++;}});languageFilter.resultHandler(query);});},resultHandler:function(query){if(this.resultCount===0){this.$suggestion.val('');this.$element.trigger('noresults.uls',query);}else{this.$element.trigger('resultsfound.uls',[query,this.resultCount]);}},autofill:function(langCode,languageName){if(!this.$suggestion.length){return;}if(!this.$element.val()){this.$suggestion.val('');return;}this.selectedLanguage=langCode;languageName=languageName||this.options.languages[langCode];if(!languageName){return;}var autonym,userInput=this.$element.val(),suggestion=userInput+languageName.substring(userInput.length,languageName.length);if(suggestion.toLowerCase()!==languageName.toLowerCase()){autonym=$.uls.data.getAutonym(langCode)||'';suggestion=userInput+autonym.substring(userInput.length,autonym.length);if(suggestion!==autonym){suggestion='';}}if(!isVisualPrefix(userInput,suggestion)){suggestion='';}this.
$suggestion.val(suggestion);},render:function(langCode){var $target=this.options.$target;if(!$target){return false;}return $target.append(langCode);},escapeRegex:function(value){return value.replace(/[\-\[\]{}()*+?.,\\\^$\|#\s]/g,'\\$&');},filter:function(langCode,searchTerm){var matcher=new RegExp('^'+this.escapeRegex(searchTerm),'i'),languageName=this.options.languages[langCode];return matcher.test(languageName)||matcher.test($.uls.data.getAutonym(langCode))||matcher.test(langCode)||matcher.test($.uls.data.getScript(langCode));},eventSupported:function(eventName){var isSupported=eventName in this.$element;if(!isSupported){this.$element.setAttribute(eventName,'return;');isSupported=typeof this.$element[eventName]==='function';}return isSupported;}};$.fn.languagefilter=function(option){return this.each(function(){var $this=$(this),data=$this.data('languagefilter'),options=typeof option==='object'&&option;if(!data){$this.data('languagefilter',(data=new LanguageFilter(this,options)));}if
(typeof option==='string'){data[option]();}});};$.fn.languagefilter.defaults={$target:null,searchAPI:null,languages:null,onSelect:null};$.fn.languagefilter.Constructor=LanguageFilter;function isVisualPrefix(prefix,string){var prebases='െേൈൊോൌெேைொோௌେୈୋୌિਿिিেৈোৌෙේෛොෝෞ';return prebases.indexOf(string[prefix.length])<=0;}}(jQuery));(function($){'use strict';var RegionSelector;RegionSelector=function(element,options){this.$element=$(element);this.options=$.extend({},$.fn.regionselector.defaults,options);this.$element.addClass('regionselector');this.regions=[];this.cache=null;this.regionGroup=this.$element.data('regiongroup');this.init();this.listen();};RegionSelector.prototype={constructor:RegionSelector,init:function(){var region=this.$element.data('region');this.regions=$.uls.data.getRegionsInGroup(this.regionGroup);if(region){this.regions.push(region);}},test:function(langCode){var region,i,langRegions=$.uls.data.getRegions(
langCode);for(i=0;i<this.regions.length;i++){region=this.regions[i];if($.inArray(region,langRegions)>=0){this.render(langCode,region);this.cache[langCode]=region;return;}}},show:function(){var result,languagesByScriptGroup,scriptGroup,languages,i,$element=this.options.$target&&this.options.$target.$element,$parent=$element&&$element.parent(),$prev=$element&&$element.prev();if($element&&$parent){$element.detach();}if(this.cache){result=null;for(result in this.cache){this.render(result,this.cache[result]);}}else{this.cache={};languagesByScriptGroup=$.uls.data.getLanguagesByScriptGroup(this.options.languages);for(scriptGroup in $.uls.data.scriptgroups){languages=languagesByScriptGroup[scriptGroup];if(!languages){continue;}languages.sort($.uls.data.sortByAutonym);for(i=0;i<languages.length;i++){this.test(languages[i]);}}}if($element&&$parent){if($prev){$prev.after($element);}else{$parent.append($element);}}if(this.options.success){this.options.success(this);}},render:function(langCode,
region){var $target=this.options.$target;if(!$target){return;}$target.append(langCode,region);},listen:function(){this.$element.on('click',$.proxy(this.click,this));},click:function(){var $list,$firstTargetRegion;if(this.$element.hasClass('active')){return;}$list=this.options.$target.$element;$firstTargetRegion=$list.find('#'+this.regions[0]);$list.scrollTop($firstTargetRegion.offset().top-$list.offset().top+$list.scrollTop());$('.regionselector').removeClass('active');if(this.regionGroup){this.$element.addClass('active');}}};$.fn.regionselector=function(option){return this.each(function(){var $this=$(this),data=$this.data('regionselector'),options=typeof option==='object'&&option;if(!data){$this.data('regionselector',(data=new RegionSelector(this,options)));}if(typeof option==='string'){data[option]();}});};$.fn.regionselector.defaults={$target:null,success:null,noresults:null,languages:null};$.fn.regionselector.Constructor=RegionSelector;}(jQuery));;},{"css":[
".uls-trigger{background:transparent url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABsAAAAQCAMAAADQzfSkAAABqlBMVEX////f3/+Ov+/n5+fp6enp6eno6Ojp6enn5+ff39/q6urp6enp6enp6enq6urp6en////q6urr6+upv+rU1NTJycnR0dEaGhrp6enT4/SEuuK9vb3l5eU2ktCxsbFdXV1paWmzwc9ITFDo6OhaWlpsbGxtbW2BipSZpK/X19d2dnZ8hI2/v79PT09gZm2CgoLIyMjD0eGksL1JTVHM2+spKywnKCkcHBzAzt3I1+cxMzZxcXFkZGSvr69WW2C8vLyFjphqcXiLlZ8dHh4gISLa2trQ3/Dc3NzZ2dl7e3uioqIfHyBCRko9QEPh4eFgYGDGxsZoaGiPj4/Ly8uRm6a6yNcbGxuSnKfL2uqVn6scHR20tLR/f3+Kioq4uLienp54gIipqanA2e+71u9GSk5yeoKgoKCAgIB0dHRLS0tlZWWDg4PBwcHFxcWxvsxkanGapbCKlJ7O4fNXo9hQn9bM3/OPmaRfZWve3t6mpqbR0dG+vr6JiYnKyspPVFl1s99+fn5srdzm5ubNzc1BREh2s99xsN7S0tIxMzUiIyQ2OTt/iJFwcHBbYWc3S28lAAAAF3RSTlMACBAg7P3LiTYIX6LmmDzeAYMnDN+1MJx17ncAAAEQSURBVHheddBTb0VREIbhVduYWVuHRm3btm3bNv9zJ2v3IE36Xk3yZG4+xkMKw0BREYwJMzkcO38MY37tG6AmYN48YZFxwsbeiys6y/02rT1Wa4TxwoYgpx4adLMbfRubs9tk0cJuYK8ACv1/Xy5LLlIYS5bf2FTUUlJapptiqKwyuOfJEsjq4M3j+YBPYc02X6utTWnvQEwk6wJRNxn29Pb1D2iIg0bEJMaHYWTU6RyfABPZ5BTa7xBxxo2YzPgcPPGFRb4Ey2Qrq2vrXlRk6xampDK+a94/ODw6PjGfkp2dX1y6ZOvVNWKavsutqt6HbGZ5QCqdMUmSnlXqhY6M12CZtKcaUnhtsKz/Tc5m7AfjN0jzWIipawAAAABJRU5ErkJggg==) no-repeat scroll left center;background:transparent url(//bits.wikimedia.org/static-1.23wmf10/extensions/UniversalLanguageSelector/lib/jquery.uls/css/../images/icon-language.png?2014-01-09T16:51:40Z) no-repeat scroll left center!ie;background-image:-webkit-linear-gradient(transparent,transparent),url(data:image/svg+xml;base64,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);background-image:-webkit-linear-gradient(transparent,transparent),url(//bits.wikimedia.org/static-1.23wmf10/extensions/UniversalLanguageSelector/lib/jquery.uls/css/../images/icon-language.svg?2014-01-09T16:51:40Z)!ie;background-image:-moz-linear-gradient(transparent,transparent),url(data:image/svg+xml;base64,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);background-image:-moz-linear-gradient(transparent,transparent),url(//bits.wikimedia.org/static-1.23wmf10/extensions/UniversalLanguageSelector/lib/jquery.uls/css/../images/icon-language.svg?2014-01-09T16:51:40Z)!ie;background-image:linear-gradient(transparent,transparent),url(data:image/svg+xml;base64,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);background-image:linear-gradient(transparent,transparent),url(//bits.wikimedia.org/static-1.23wmf10/extensions/UniversalLanguageSelector/lib/jquery.uls/css/../images/icon-language.svg?2014-01-09T16:51:40Z)!ie;padding-left:30px}.uls-menu{position:absolute;z-index:1000;display:none;margin-top:1px; background-color:#ffffff;border:1px solid #ccc;border:1px solid rgba(0,0,0,0.2);-webkit-border-radius:5px;-moz-border-radius:5px;border-radius:5px;-webkit-box-shadow:0 5px 10px rgba(0,0,0,0.2);-moz-box-shadow:0 5px 10px rgba(0,0,0,0.2);box-shadow:0 5px 10px rgba(0,0,0,0.2);-webkit-background-clip:padding-box;-moz-background-clip:padding;background-clip:padding-box}.uls-wide{min-width:715px;width:45%}.uls-title-region a{padding-left:15px}.uls-menu .uls-title{font-weight:normal;border:none;padding-top:1.25em;padding-left:15px;padding-bottom:3px;font-size:18pt;line-height:1.25em;color:#555}.uls-menu .uls-no-results-found-title{font-size:16pt;font-weight:bold;line-height:1.5em;padding-left:6px;padding-top:10px;margin-top:0;margin-bottom:15px;border-bottom:none;color:#555}.uls-menu .uls-lcd-region-section .uls-lcd-region-title{color:#777;font-size:14pt;font-weight:lighter;line-height:1.5em;padding-left:0;margin-top:0;margin-bottom:10px;border-bottom:none}.uls-worldmap{background:transparent url(data:image/png;base64,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) no-repeat scroll right top;background:transparent url(//bits.wikimedia.org/static-1.23wmf10/extensions/UniversalLanguageSelector/lib/jquery.uls/css/../images/world_map.png?2014-01-09T16:51:40Z) no-repeat scroll right top!ie;background-image:-webkit-linear-gradient(transparent,transparent),url(//bits.wikimedia.org/static-1.23wmf10/extensions/UniversalLanguageSelector/lib/jquery.uls/css/../images/world_map.svg?2014-01-09T16:51:40Z);background-image:-moz-linear-gradient(transparent,transparent),url(//bits.wikimedia.org/static-1.23wmf10/extensions/UniversalLanguageSelector/lib/jquery.uls/css/../images/world_map.svg?2014-01-09T16:51:40Z);background-image:linear-gradient(transparent,transparent),url(//bits.wikimedia.org/static-1.23wmf10/extensions/UniversalLanguageSelector/lib/jquery.uls/css/../images/world_map.svg?2014-01-09T16:51:40Z);background-size:100%}div.uls-region{cursor:pointer;padding:0;margin:0;height:120px;border-bottom-color:transparent;border-bottom-style:solid;border-bottom-width:2px}.uls-worldmap .uls-region{  float:left}.uls-region a{bottom:2px;left:2px;padding:0;position:absolute;font-size:13px;line-height:1.2em;text-decoration:none;overflow:hidden;text-overflow:ellipsis;width:99%}.uls-region:hover{ background:#3366bb;background:rgba(51,102,187,0.1);filter:progid:DXImageTransform.Microsoft.gradient(startColorstr=#253366bb,endColorstr=#253366bb );-ms-filter:\"progid:DXImageTransform.Microsoft.gradient(startColorstr=#253366bb,endColorstr=#253366bb)\"}.map-block .active{border-bottom-color:#3366bb;border-bottom-style:solid}.uls-menu .row .map-block{top:1px;margin-right:0;padding-right:0;float:right;overflow:hidden;opacity:0.7;-moz-transition:opacity 0.2s linear;-o-transition:opacity 0.2s linear;-webkit-transition:opacity 0.2s linear;transition:opacity 0.2s linear}.map-block a{color:#333;opacity:0;-moz-transition:opacity 0.15s linear;-o-transition:opacity 0.15s linear;-webkit-transition:opacity 0.15s linear;transition:opacity 0.15s linear}.uls-menu .map-block:hover,.uls-menu .map-block:hover a{opacity:1;color:#333}.map-block .uls-region-1{border-color:transparent}.map-block:hover .active{border-color:#3366bb}.map-block .active a{font-weight:bold}.icon-close{background:transparent url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAA8AAAAPBAMAAADJ+Ih5AAAAFVBMVEX///9YWFhVVVVVVVVYWFhVVVVVVVXoAYr3AAAABnRSTlMAIODAPPuxK62GAAAASElEQVQIW2NgNGRgYAARQkkCEMIsTZGBUS3NgEEoLUkAhEE8FTWgKFA+LRUkwAASAgswMLimpTowIIvA1MB1wc1BmAyzC2Y7AAiaExMXmNVGAAAAAElFTkSuQmCC) no-repeat scroll center center;background:transparent url(//bits.wikimedia.org/static-1.23wmf10/extensions/UniversalLanguageSelector/lib/jquery.uls/css/../images/close.png?2014-01-09T16:51:40Z) no-repeat scroll center center!ie;background-image:-webkit-linear-gradient(transparent,transparent),url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9Im5vIj8+CjwhLS0gQ3JlYXRlZCB3aXRoIElua3NjYXBlIChodHRwOi8vd3d3Lmlua3NjYXBlLm9yZy8pIC0tPgoKPHN2ZwogICB4bWxuczpkYz0iaHR0cDovL3B1cmwub3JnL2RjL2VsZW1lbnRzLzEuMS8iCiAgIHhtbG5zOmNjPSJodHRwOi8vY3JlYXRpdmVjb21tb25zLm9yZy9ucyMiCiAgIHhtbG5zOnJkZj0iaHR0cDovL3d3dy53My5vcmcvMTk5OS8wMi8yMi1yZGYtc3ludGF4LW5zIyIKICAgeG1sbnM6c3ZnPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIKICAgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIgogICB2ZXJzaW9uPSIxLjEiCiAgIHdpZHRoPSIxMy41OTE5MDEiCiAgIGhlaWdodD0iMTMuNTkxODg0IgogICBpZD0ic3ZnMiI+CiAgPGRlZnMKICAgICBpZD0iZGVmczQiIC8+CiAgPG1ldGFkYXRhCiAgICAgaWQ9Im1ldGFkYXRhNyI+CiAgICA8cmRmOlJERj4KICAgICAgPGNjOldvcmsKICAgICAgICAgcmRmOmFib3V0PSIiPgogICAgICAgIDxkYzpmb3JtYXQ+aW1hZ2Uvc3ZnK3htbDwvZGM6Zm9ybWF0PgogICAgICAgIDxkYzp0eXBlCiAgICAgICAgICAgcmRmOnJlc291cmNlPSJodHRwOi8vcHVybC5vcmcvZGMvZGNtaXR5cGUvU3RpbGxJbWFnZSIgLz4KICAgICAgICA8ZGM6dGl0bGU+PC9kYzp0aXRsZT4KICAgICAgPC9jYzpXb3JrPgogICAgPC9yZGY6UkRGPgogIDwvbWV0YWRhdGE+CiAgPGcKICAgICB0cmFuc2Zvcm09InRyYW5zbGF0ZSgtNTc4LjY1ODUsLTMwOS4zMDE0MikiCiAgICAgaWQ9ImxheWVyMSI+CiAgICA8cmVjdAogICAgICAgd2lkdGg9IjMuMjAzNjM3NiIKICAgICAgIGhlaWdodD0iMTYuMDE4MTg4IgogICAgICAgeD0iMTg4Ljg2MjQxIgogICAgICAgeT0iNjI5LjQ4NDMxIgogICAgICAgdHJhbnNmb3JtPSJtYXRyaXgoMC43MDcxMDY3OCwtMC43MDcxMDY3OCwwLjcwNzEwNjc4LDAuNzA3MTA2NzgsMCwwKSIKICAgICAgIGlkPSJyZWN0OTM3Mi00LTktNS00LTAiCiAgICAgICBzdHlsZT0iZmlsbDojNTU1NTU1O2ZpbGwtb3BhY2l0eToxO3N0cm9rZTpub25lIiAvPgogICAgPHJlY3QKICAgICAgIHdpZHRoPSIzLjIwMzYzNzYiCiAgICAgICBoZWlnaHQ9IjE2LjAxODE4OCIKICAgICAgIHg9Ii02MzkuMDk1MjEiCiAgICAgICB5PSIxODIuNDU1MTIiCiAgICAgICB0cmFuc2Zvcm09Im1hdHJpeCgtMC43MDcxMDY3OCwtMC43MDcxMDY3OCwwLjcwNzEwNjc4LC0wLjcwNzEwNjc4LDAsMCkiCiAgICAgICBpZD0icmVjdDkzNzItNS02LTQ0LTctNy03IgogICAgICAgc3R5bGU9ImZpbGw6IzU1NTU1NTtmaWxsLW9wYWNpdHk6MTtzdHJva2U6bm9uZSIgLz4KICA8L2c+Cjwvc3ZnPgo=);background-image:-webkit-linear-gradient(transparent,transparent),url(//bits.wikimedia.org/static-1.23wmf10/extensions/UniversalLanguageSelector/lib/jquery.uls/css/../images/close.svg?2014-01-09T16:51:40Z)!ie;background-image:-moz-linear-gradient(transparent,transparent),url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9Im5vIj8+CjwhLS0gQ3JlYXRlZCB3aXRoIElua3NjYXBlIChodHRwOi8vd3d3Lmlua3NjYXBlLm9yZy8pIC0tPgoKPHN2ZwogICB4bWxuczpkYz0iaHR0cDovL3B1cmwub3JnL2RjL2VsZW1lbnRzLzEuMS8iCiAgIHhtbG5zOmNjPSJodHRwOi8vY3JlYXRpdmVjb21tb25zLm9yZy9ucyMiCiAgIHhtbG5zOnJkZj0iaHR0cDovL3d3dy53My5vcmcvMTk5OS8wMi8yMi1yZGYtc3ludGF4LW5zIyIKICAgeG1sbnM6c3ZnPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIKICAgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIgogICB2ZXJzaW9uPSIxLjEiCiAgIHdpZHRoPSIxMy41OTE5MDEiCiAgIGhlaWdodD0iMTMuNTkxODg0IgogICBpZD0ic3ZnMiI+CiAgPGRlZnMKICAgICBpZD0iZGVmczQiIC8+CiAgPG1ldGFkYXRhCiAgICAgaWQ9Im1ldGFkYXRhNyI+CiAgICA8cmRmOlJERj4KICAgICAgPGNjOldvcmsKICAgICAgICAgcmRmOmFib3V0PSIiPgogICAgICAgIDxkYzpmb3JtYXQ+aW1hZ2Uvc3ZnK3htbDwvZGM6Zm9ybWF0PgogICAgICAgIDxkYzp0eXBlCiAgICAgICAgICAgcmRmOnJlc291cmNlPSJodHRwOi8vcHVybC5vcmcvZGMvZGNtaXR5cGUvU3RpbGxJbWFnZSIgLz4KICAgICAgICA8ZGM6dGl0bGU+PC9kYzp0aXRsZT4KICAgICAgPC9jYzpXb3JrPgogICAgPC9yZGY6UkRGPgogIDwvbWV0YWRhdGE+CiAgPGcKICAgICB0cmFuc2Zvcm09InRyYW5zbGF0ZSgtNTc4LjY1ODUsLTMwOS4zMDE0MikiCiAgICAgaWQ9ImxheWVyMSI+CiAgICA8cmVjdAogICAgICAgd2lkdGg9IjMuMjAzNjM3NiIKICAgICAgIGhlaWdodD0iMTYuMDE4MTg4IgogICAgICAgeD0iMTg4Ljg2MjQxIgogICAgICAgeT0iNjI5LjQ4NDMxIgogICAgICAgdHJhbnNmb3JtPSJtYXRyaXgoMC43MDcxMDY3OCwtMC43MDcxMDY3OCwwLjcwNzEwNjc4LDAuNzA3MTA2NzgsMCwwKSIKICAgICAgIGlkPSJyZWN0OTM3Mi00LTktNS00LTAiCiAgICAgICBzdHlsZT0iZmlsbDojNTU1NTU1O2ZpbGwtb3BhY2l0eToxO3N0cm9rZTpub25lIiAvPgogICAgPHJlY3QKICAgICAgIHdpZHRoPSIzLjIwMzYzNzYiCiAgICAgICBoZWlnaHQ9IjE2LjAxODE4OCIKICAgICAgIHg9Ii02MzkuMDk1MjEiCiAgICAgICB5PSIxODIuNDU1MTIiCiAgICAgICB0cmFuc2Zvcm09Im1hdHJpeCgtMC43MDcxMDY3OCwtMC43MDcxMDY3OCwwLjcwNzEwNjc4LC0wLjcwNzEwNjc4LDAsMCkiCiAgICAgICBpZD0icmVjdDkzNzItNS02LTQ0LTctNy03IgogICAgICAgc3R5bGU9ImZpbGw6IzU1NTU1NTtmaWxsLW9wYWNpdHk6MTtzdHJva2U6bm9uZSIgLz4KICA8L2c+Cjwvc3ZnPgo=);background-image:-moz-linear-gradient(transparent,transparent),url(//bits.wikimedia.org/static-1.23wmf10/extensions/UniversalLanguageSelector/lib/jquery.uls/css/../images/close.svg?2014-01-09T16:51:40Z)!ie;background-image:linear-gradient(transparent,transparent),url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9Im5vIj8+CjwhLS0gQ3JlYXRlZCB3aXRoIElua3NjYXBlIChodHRwOi8vd3d3Lmlua3NjYXBlLm9yZy8pIC0tPgoKPHN2ZwogICB4bWxuczpkYz0iaHR0cDovL3B1cmwub3JnL2RjL2VsZW1lbnRzLzEuMS8iCiAgIHhtbG5zOmNjPSJodHRwOi8vY3JlYXRpdmVjb21tb25zLm9yZy9ucyMiCiAgIHhtbG5zOnJkZj0iaHR0cDovL3d3dy53My5vcmcvMTk5OS8wMi8yMi1yZGYtc3ludGF4LW5zIyIKICAgeG1sbnM6c3ZnPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIKICAgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIgogICB2ZXJzaW9uPSIxLjEiCiAgIHdpZHRoPSIxMy41OTE5MDEiCiAgIGhlaWdodD0iMTMuNTkxODg0IgogICBpZD0ic3ZnMiI+CiAgPGRlZnMKICAgICBpZD0iZGVmczQiIC8+CiAgPG1ldGFkYXRhCiAgICAgaWQ9Im1ldGFkYXRhNyI+CiAgICA8cmRmOlJERj4KICAgICAgPGNjOldvcmsKICAgICAgICAgcmRmOmFib3V0PSIiPgogICAgICAgIDxkYzpmb3JtYXQ+aW1hZ2Uvc3ZnK3htbDwvZGM6Zm9ybWF0PgogICAgICAgIDxkYzp0eXBlCiAgICAgICAgICAgcmRmOnJlc291cmNlPSJodHRwOi8vcHVybC5vcmcvZGMvZGNtaXR5cGUvU3RpbGxJbWFnZSIgLz4KICAgICAgICA8ZGM6dGl0bGU+PC9kYzp0aXRsZT4KICAgICAgPC9jYzpXb3JrPgogICAgPC9yZGY6UkRGPgogIDwvbWV0YWRhdGE+CiAgPGcKICAgICB0cmFuc2Zvcm09InRyYW5zbGF0ZSgtNTc4LjY1ODUsLTMwOS4zMDE0MikiCiAgICAgaWQ9ImxheWVyMSI+CiAgICA8cmVjdAogICAgICAgd2lkdGg9IjMuMjAzNjM3NiIKICAgICAgIGhlaWdodD0iMTYuMDE4MTg4IgogICAgICAgeD0iMTg4Ljg2MjQxIgogICAgICAgeT0iNjI5LjQ4NDMxIgogICAgICAgdHJhbnNmb3JtPSJtYXRyaXgoMC43MDcxMDY3OCwtMC43MDcxMDY3OCwwLjcwNzEwNjc4LDAuNzA3MTA2NzgsMCwwKSIKICAgICAgIGlkPSJyZWN0OTM3Mi00LTktNS00LTAiCiAgICAgICBzdHlsZT0iZmlsbDojNTU1NTU1O2ZpbGwtb3BhY2l0eToxO3N0cm9rZTpub25lIiAvPgogICAgPHJlY3QKICAgICAgIHdpZHRoPSIzLjIwMzYzNzYiCiAgICAgICBoZWlnaHQ9IjE2LjAxODE4OCIKICAgICAgIHg9Ii02MzkuMDk1MjEiCiAgICAgICB5PSIxODIuNDU1MTIiCiAgICAgICB0cmFuc2Zvcm09Im1hdHJpeCgtMC43MDcxMDY3OCwtMC43MDcxMDY3OCwwLjcwNzEwNjc4LC0wLjcwNzEwNjc4LDAsMCkiCiAgICAgICBpZD0icmVjdDkzNzItNS02LTQ0LTctNy03IgogICAgICAgc3R5bGU9ImZpbGw6IzU1NTU1NTtmaWxsLW9wYWNpdHk6MTtzdHJva2U6bm9uZSIgLz4KICA8L2c+Cjwvc3ZnPgo=);background-image:linear-gradient(transparent,transparent),url(//bits.wikimedia.org/static-1.23wmf10/extensions/UniversalLanguageSelector/lib/jquery.uls/css/../images/close.svg?2014-01-09T16:51:40Z)!ie;float:right;padding:15px;cursor:pointer}.uls-menu .languagefilter{background-color:transparent;border:1px solid #c9c9c9;border-radius:2px 2px 2px 2px;box-shadow:0 1px 2px rgba(0,0,0,0.1) inset;color:#333;display:block;padding:6px;-moz-transition:border 0.15s linear 0s;-o-transition:border 0.15s linear 0s;-webkit-transition:border 0.15s linear 0s;transition:border 0.15s linear 0s}.uls-menu .languagefilter:focus{border:1px solid #3366bb}.uls-menu .search{position:relative;filter:progid:DXImageTransform.Microsoft.gradient(startColorstr='#F0F0F0',endColorstr='#FBFBFB');background:#f8f8f8;background:-webkit-gradient(linear,left top,left bottom,from(#F0F0F0),to(#FBFBFB));background:-webkit-linear-gradient(top,#F0F0F0,#FBFBFB);background:-moz-linear-gradient(top,#F0F0F0,#FBFBFB);background:-o-linear-gradient(top,#F0F0F0,#FBFBFB);background:linear-gradient(#F0F0F0,#FBFBFB);border-top-color:#AAA;border-top-style:solid;border-top-width:1px;padding:0.8em 0;border-bottom-width:1px;border-bottom-style:solid;border-bottom-color:#DDD}.uls-menu .search-label{background:transparent url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAB4AAAAeCAMAAAAM7l6QAAAA+VBMVEX///9VVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVUVFRUVFQAAABVVVVWVlZVVVVUVFRWVlZVVVVSUlJVVVVTU1NUVFRVVVVTU1NVVVWAgIBWVlZVVVVVVVVVVVVVVVVUVFRVVVVUVFRWVlZTU1NVVVVVVVVAQEBVVVVmZmZVVVVVVVVVVVVWVlZVVVVUVFRVVVVUVFRVVVVWVlZUVFRVVVVVVVVVVVVVVVVVVVVVVVVQUFBUVFRWVlZXV1dVVVVUVFRVVVVTU1NVVVVVVVVWVlZOTk5TU1NVVVVVVVVXV1dVVVVVVVVUVFRVVVVVVVVdXV1VVVVVVVUA2BLyAAAAUnRSTlMAD8jxe+7NA9GwSU8B/lAYZFysH/A3jr8r3gKVyuBCunD7YYMxaagEMAW5+R6eBpcSPVprndqE3+nhGxBGoTJFOucl99V3DS7PZjhIeKn6kwvLXHAdYgAAAPxJREFUeF7Vz9VuAkEARuFZ1lmkUNylSJG6u7ue93+YJoXMzrAN9/3vTr5kRMyWzhSKdjlrxV3xx1ZM5quVIrjaBODYBBhbgwXNAdPLLZG42bkDfJ2bUD+bx8ZBGzravXBohBmAOQkzbZJsCGXn0A8rA5tC3ek1dkVWAbaFtj0YyiiSfNB5F1oybPaFvivoyihztMBx6MnIwonOFgRqpHT2YU096ttV9aKNE5Zbg3tF1z39uNKY20aoVfAS+lNIfn7N4vEJcAyVBz5Qrz6/vL69fwAQ01x0TOQ8J+qTvj1DJ5UwYlEXlWGr2wt+/6u7vn/jI7HMc3mxxEd58QNaPTmU1TEhpgAAAABJRU5ErkJggg==) no-repeat scroll right center;background:transparent url(//bits.wikimedia.org/static-1.23wmf10/extensions/UniversalLanguageSelector/lib/jquery.uls/css/../images/search.png?2014-01-09T16:51:40Z) no-repeat scroll right center!ie;background-image:-webkit-linear-gradient(transparent,transparent),url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9Im5vIj8+CjwhLS0gQ3JlYXRlZCB3aXRoIElua3NjYXBlIChodHRwOi8vd3d3Lmlua3NjYXBlLm9yZy8pIC0tPgo8c3ZnIHhtbG5zOnJkZj0iaHR0cDovL3d3dy53My5vcmcvMTk5OS8wMi8yMi1yZGYtc3ludGF4LW5zIyIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiBoZWlnaHQ9IjMyIiB3aWR0aD0iMzIiIHZlcnNpb249IjEuMSIgeG1sbnM6Y2M9Imh0dHA6Ly9jcmVhdGl2ZWNvbW1vbnMub3JnL25zIyIgeG1sbnM6ZGM9Imh0dHA6Ly9wdXJsLm9yZy9kYy9lbGVtZW50cy8xLjEvIj4KPG1ldGFkYXRhPgo8cmRmOlJERj4KPGNjOldvcmsgcmRmOmFib3V0PSIiPgo8ZGM6Zm9ybWF0PmltYWdlL3N2Zyt4bWw8L2RjOmZvcm1hdD4KPGRjOnR5cGUgcmRmOnJlc291cmNlPSJodHRwOi8vcHVybC5vcmcvZGMvZGNtaXR5cGUvU3RpbGxJbWFnZSIvPgo8ZGM6dGl0bGUvPgo8L2NjOldvcms+CjwvcmRmOlJERj4KPC9tZXRhZGF0YT4KPGcgdHJhbnNmb3JtPSJ0cmFuc2xhdGUoLTU3Ni41MTE1NCwtMjk1Ljg2NzY1KSI+CjxwYXRoIGZpbGw9IiM1NTUiIGQ9Im01NzkuODksMjk5LjI0YzQuNTAyNy00LjUwMjcsMTEuODA2LTQuNTAyNywxNi4zMDgsMC4wMDAwNiw0LjA3MjIsNC4wNzIyLDQuNDE2OSwxMC40MjUsMS4xMjMyLDE0LjkzNmwxMS4xOTEsMTEuMTkxLTIuNDk2MiwyLjQ5NjItMTEuMTkxLTExLjE5MWMtNC41MTAyLDMuMjkzNi0xMC44NjMsMi45NDkxLTE0LjkzNS0xLjEyMzQtNC41MDI4LTQuNTAyNi00LjUwMjgtMTEuODA2LTAuMDAwMDgtMTYuMzA4em0yLjEyMTgsMi4xMjE5Yy0zLjM0MjMsMy4zNDIxLTMuMzgzOSw4Ljc2NDItMC4wNDE2LDEyLjEwNywzLjM0MjMsMy4zNDIyLDguODA1OSwzLjM0MjIsMTIuMTQ4LTAuMDAwMDIsMy4zNDIyLTMuMzQyNCwzLjMwMDYtOC43NjQzLTAuMDQxNy0xMi4xMDctMy4zNDIyLTMuMzQyMS04LjcyMjYtMy4zNDIxLTEyLjA2NSwwLjAwMDEzeiIvPgo8L2c+Cjwvc3ZnPgo=);background-image:-webkit-linear-gradient(transparent,transparent),url(//bits.wikimedia.org/static-1.23wmf10/extensions/UniversalLanguageSelector/lib/jquery.uls/css/../images/search.svg?2014-01-09T16:51:40Z)!ie;background-image:-moz-linear-gradient(transparent,transparent),url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9Im5vIj8+CjwhLS0gQ3JlYXRlZCB3aXRoIElua3NjYXBlIChodHRwOi8vd3d3Lmlua3NjYXBlLm9yZy8pIC0tPgo8c3ZnIHhtbG5zOnJkZj0iaHR0cDovL3d3dy53My5vcmcvMTk5OS8wMi8yMi1yZGYtc3ludGF4LW5zIyIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiBoZWlnaHQ9IjMyIiB3aWR0aD0iMzIiIHZlcnNpb249IjEuMSIgeG1sbnM6Y2M9Imh0dHA6Ly9jcmVhdGl2ZWNvbW1vbnMub3JnL25zIyIgeG1sbnM6ZGM9Imh0dHA6Ly9wdXJsLm9yZy9kYy9lbGVtZW50cy8xLjEvIj4KPG1ldGFkYXRhPgo8cmRmOlJERj4KPGNjOldvcmsgcmRmOmFib3V0PSIiPgo8ZGM6Zm9ybWF0PmltYWdlL3N2Zyt4bWw8L2RjOmZvcm1hdD4KPGRjOnR5cGUgcmRmOnJlc291cmNlPSJodHRwOi8vcHVybC5vcmcvZGMvZGNtaXR5cGUvU3RpbGxJbWFnZSIvPgo8ZGM6dGl0bGUvPgo8L2NjOldvcms+CjwvcmRmOlJERj4KPC9tZXRhZGF0YT4KPGcgdHJhbnNmb3JtPSJ0cmFuc2xhdGUoLTU3Ni41MTE1NCwtMjk1Ljg2NzY1KSI+CjxwYXRoIGZpbGw9IiM1NTUiIGQ9Im01NzkuODksMjk5LjI0YzQuNTAyNy00LjUwMjcsMTEuODA2LTQuNTAyNywxNi4zMDgsMC4wMDAwNiw0LjA3MjIsNC4wNzIyLDQuNDE2OSwxMC40MjUsMS4xMjMyLDE0LjkzNmwxMS4xOTEsMTEuMTkxLTIuNDk2MiwyLjQ5NjItMTEuMTkxLTExLjE5MWMtNC41MTAyLDMuMjkzNi0xMC44NjMsMi45NDkxLTE0LjkzNS0xLjEyMzQtNC41MDI4LTQuNTAyNi00LjUwMjgtMTEuODA2LTAuMDAwMDgtMTYuMzA4em0yLjEyMTgsMi4xMjE5Yy0zLjM0MjMsMy4zNDIxLTMuMzgzOSw4Ljc2NDItMC4wNDE2LDEyLjEwNywzLjM0MjMsMy4zNDIyLDguODA1OSwzLjM0MjIsMTIuMTQ4LTAuMDAwMDIsMy4zNDIyLTMuMzQyNCwzLjMwMDYtOC43NjQzLTAuMDQxNy0xMi4xMDctMy4zNDIyLTMuMzQyMS04LjcyMjYtMy4zNDIxLTEyLjA2NSwwLjAwMDEzeiIvPgo8L2c+Cjwvc3ZnPgo=);background-image:-moz-linear-gradient(transparent,transparent),url(//bits.wikimedia.org/static-1.23wmf10/extensions/UniversalLanguageSelector/lib/jquery.uls/css/../images/search.svg?2014-01-09T16:51:40Z)!ie;background-image:linear-gradient(transparent,transparent),url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9Im5vIj8+CjwhLS0gQ3JlYXRlZCB3aXRoIElua3NjYXBlIChodHRwOi8vd3d3Lmlua3NjYXBlLm9yZy8pIC0tPgo8c3ZnIHhtbG5zOnJkZj0iaHR0cDovL3d3dy53My5vcmcvMTk5OS8wMi8yMi1yZGYtc3ludGF4LW5zIyIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiBoZWlnaHQ9IjMyIiB3aWR0aD0iMzIiIHZlcnNpb249IjEuMSIgeG1sbnM6Y2M9Imh0dHA6Ly9jcmVhdGl2ZWNvbW1vbnMub3JnL25zIyIgeG1sbnM6ZGM9Imh0dHA6Ly9wdXJsLm9yZy9kYy9lbGVtZW50cy8xLjEvIj4KPG1ldGFkYXRhPgo8cmRmOlJERj4KPGNjOldvcmsgcmRmOmFib3V0PSIiPgo8ZGM6Zm9ybWF0PmltYWdlL3N2Zyt4bWw8L2RjOmZvcm1hdD4KPGRjOnR5cGUgcmRmOnJlc291cmNlPSJodHRwOi8vcHVybC5vcmcvZGMvZGNtaXR5cGUvU3RpbGxJbWFnZSIvPgo8ZGM6dGl0bGUvPgo8L2NjOldvcms+CjwvcmRmOlJERj4KPC9tZXRhZGF0YT4KPGcgdHJhbnNmb3JtPSJ0cmFuc2xhdGUoLTU3Ni41MTE1NCwtMjk1Ljg2NzY1KSI+CjxwYXRoIGZpbGw9IiM1NTUiIGQ9Im01NzkuODksMjk5LjI0YzQuNTAyNy00LjUwMjcsMTEuODA2LTQuNTAyNywxNi4zMDgsMC4wMDAwNiw0LjA3MjIsNC4wNzIyLDQuNDE2OSwxMC40MjUsMS4xMjMyLDE0LjkzNmwxMS4xOTEsMTEuMTkxLTIuNDk2MiwyLjQ5NjItMTEuMTkxLTExLjE5MWMtNC41MTAyLDMuMjkzNi0xMC44NjMsMi45NDkxLTE0LjkzNS0xLjEyMzQtNC41MDI4LTQuNTAyNi00LjUwMjgtMTEuODA2LTAuMDAwMDgtMTYuMzA4em0yLjEyMTgsMi4xMjE5Yy0zLjM0MjMsMy4zNDIxLTMuMzgzOSw4Ljc2NDItMC4wNDE2LDEyLjEwNywzLjM0MjMsMy4zNDIyLDguODA1OSwzLjM0MjIsMTIuMTQ4LTAuMDAwMDIsMy4zNDIyLTMuMzQyNCwzLjMwMDYtOC43NjQzLTAuMDQxNy0xMi4xMDctMy4zNDIyLTMuMzQyMS04LjcyMjYtMy4zNDIxLTEyLjA2NSwwLjAwMDEzeiIvPgo8L2c+Cjwvc3ZnPgo=);background-image:linear-gradient(transparent,transparent),url(//bits.wikimedia.org/static-1.23wmf10/extensions/UniversalLanguageSelector/lib/jquery.uls/css/../images/search.svg?2014-01-09T16:51:40Z)!ie;background-size:30px;height:32px;width:32px;float:right}.uls-menu .languagefilter-clear{background:transparent url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAA8AAAAPBAMAAADJ+Ih5AAAAGFBMVEX///9VVVVVVVVVVVVTU1NTU1NVVVVVVVUaRpmCAAAAB3RSTlMAGNe/KC75PR3D5wAAAENJREFUCFtjcBZgAAJhBwZzRSDNqG7AIFQEFAIRjOqKYAzmgUWBXFWwAFCoDCzAwMCansqAIgJXA9MFNwduMtwumO0ATJAMgKookxoAAAAASUVORK5CYII=) no-repeat scroll left center;background:transparent url(//bits.wikimedia.org/static-1.23wmf10/extensions/UniversalLanguageSelector/lib/jquery.uls/css/../images/clear.png?2014-01-09T16:51:40Z) no-repeat scroll left center!ie;background-image:-webkit-linear-gradient(transparent,transparent),url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9Im5vIj8+CjwhLS0gQ3JlYXRlZCB3aXRoIElua3NjYXBlIChodHRwOi8vd3d3Lmlua3NjYXBlLm9yZy8pIC0tPgoKPHN2ZwogICB4bWxuczpkYz0iaHR0cDovL3B1cmwub3JnL2RjL2VsZW1lbnRzLzEuMS8iCiAgIHhtbG5zOmNjPSJodHRwOi8vY3JlYXRpdmVjb21tb25zLm9yZy9ucyMiCiAgIHhtbG5zOnJkZj0iaHR0cDovL3d3dy53My5vcmcvMTk5OS8wMi8yMi1yZGYtc3ludGF4LW5zIyIKICAgeG1sbnM6c3ZnPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIKICAgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIgogICB2ZXJzaW9uPSIxLjEiCiAgIHdpZHRoPSIxMi41MjA0NzUiCiAgIGhlaWdodD0iMTIuNTIwNDciCiAgIGlkPSJzdmcyIj4KICA8ZGVmcwogICAgIGlkPSJkZWZzNCIgLz4KICA8bWV0YWRhdGEKICAgICBpZD0ibWV0YWRhdGE3Ij4KICAgIDxyZGY6UkRGPgogICAgICA8Y2M6V29yawogICAgICAgICByZGY6YWJvdXQ9IiI+CiAgICAgICAgPGRjOmZvcm1hdD5pbWFnZS9zdmcreG1sPC9kYzpmb3JtYXQ+CiAgICAgICAgPGRjOnR5cGUKICAgICAgICAgICByZGY6cmVzb3VyY2U9Imh0dHA6Ly9wdXJsLm9yZy9kYy9kY21pdHlwZS9TdGlsbEltYWdlIiAvPgogICAgICAgIDxkYzp0aXRsZT48L2RjOnRpdGxlPgogICAgICA8L2NjOldvcms+CiAgICA8L3JkZjpSREY+CiAgPC9tZXRhZGF0YT4KICA8cmVjdAogICAgIHdpZHRoPSIxLjY4ODQwNzMiCiAgICAgaGVpZ2h0PSIxNi4wMTgxODgiCiAgICAgeD0iLTAuODQ0MTkwNDgiCiAgICAgeT0iMC44NDQyMTY3NiIKICAgICB0cmFuc2Zvcm09Im1hdHJpeCgwLjcwNzEwNjc4LC0wLjcwNzEwNjc4LDAuNzA3MTA2NzgsMC43MDcxMDY3OCwwLDApIgogICAgIGlkPSJyZWN0OTM3Mi01LTYtNDQtNy03LTctNCIKICAgICBzdHlsZT0iZmlsbDojNTU1NTU1O2ZpbGwtb3BhY2l0eToxO3N0cm9rZTpub25lIiAvPgogIDxyZWN0CiAgICAgd2lkdGg9IjEuNjg4NDA3MyIKICAgICBoZWlnaHQ9IjE2LjAxODE4OCIKICAgICB4PSI4LjAwOTEwMjgiCiAgICAgeT0iLTguMDA5MDgwOSIKICAgICB0cmFuc2Zvcm09Im1hdHJpeCgwLjcwNzEwNjc4LDAuNzA3MTA2NzgsLTAuNzA3MTA2NzgsMC43MDcxMDY3OCwwLDApIgogICAgIGlkPSJyZWN0OTM3Mi01LTYtNDQtNy03LTctNC0wIgogICAgIHN0eWxlPSJmaWxsOiM1NTU1NTU7ZmlsbC1vcGFjaXR5OjE7c3Ryb2tlOm5vbmUiIC8+Cjwvc3ZnPgo=);background-image:-webkit-linear-gradient(transparent,transparent),url(//bits.wikimedia.org/static-1.23wmf10/extensions/UniversalLanguageSelector/lib/jquery.uls/css/../images/clear.svg?2014-01-09T16:51:40Z)!ie;background-image:-moz-linear-gradient(transparent,transparent),url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9Im5vIj8+CjwhLS0gQ3JlYXRlZCB3aXRoIElua3NjYXBlIChodHRwOi8vd3d3Lmlua3NjYXBlLm9yZy8pIC0tPgoKPHN2ZwogICB4bWxuczpkYz0iaHR0cDovL3B1cmwub3JnL2RjL2VsZW1lbnRzLzEuMS8iCiAgIHhtbG5zOmNjPSJodHRwOi8vY3JlYXRpdmVjb21tb25zLm9yZy9ucyMiCiAgIHhtbG5zOnJkZj0iaHR0cDovL3d3dy53My5vcmcvMTk5OS8wMi8yMi1yZGYtc3ludGF4LW5zIyIKICAgeG1sbnM6c3ZnPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIKICAgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIgogICB2ZXJzaW9uPSIxLjEiCiAgIHdpZHRoPSIxMi41MjA0NzUiCiAgIGhlaWdodD0iMTIuNTIwNDciCiAgIGlkPSJzdmcyIj4KICA8ZGVmcwogICAgIGlkPSJkZWZzNCIgLz4KICA8bWV0YWRhdGEKICAgICBpZD0ibWV0YWRhdGE3Ij4KICAgIDxyZGY6UkRGPgogICAgICA8Y2M6V29yawogICAgICAgICByZGY6YWJvdXQ9IiI+CiAgICAgICAgPGRjOmZvcm1hdD5pbWFnZS9zdmcreG1sPC9kYzpmb3JtYXQ+CiAgICAgICAgPGRjOnR5cGUKICAgICAgICAgICByZGY6cmVzb3VyY2U9Imh0dHA6Ly9wdXJsLm9yZy9kYy9kY21pdHlwZS9TdGlsbEltYWdlIiAvPgogICAgICAgIDxkYzp0aXRsZT48L2RjOnRpdGxlPgogICAgICA8L2NjOldvcms+CiAgICA8L3JkZjpSREY+CiAgPC9tZXRhZGF0YT4KICA8cmVjdAogICAgIHdpZHRoPSIxLjY4ODQwNzMiCiAgICAgaGVpZ2h0PSIxNi4wMTgxODgiCiAgICAgeD0iLTAuODQ0MTkwNDgiCiAgICAgeT0iMC44NDQyMTY3NiIKICAgICB0cmFuc2Zvcm09Im1hdHJpeCgwLjcwNzEwNjc4LC0wLjcwNzEwNjc4LDAuNzA3MTA2NzgsMC43MDcxMDY3OCwwLDApIgogICAgIGlkPSJyZWN0OTM3Mi01LTYtNDQtNy03LTctNCIKICAgICBzdHlsZT0iZmlsbDojNTU1NTU1O2ZpbGwtb3BhY2l0eToxO3N0cm9rZTpub25lIiAvPgogIDxyZWN0CiAgICAgd2lkdGg9IjEuNjg4NDA3MyIKICAgICBoZWlnaHQ9IjE2LjAxODE4OCIKICAgICB4PSI4LjAwOTEwMjgiCiAgICAgeT0iLTguMDA5MDgwOSIKICAgICB0cmFuc2Zvcm09Im1hdHJpeCgwLjcwNzEwNjc4LDAuNzA3MTA2NzgsLTAuNzA3MTA2NzgsMC43MDcxMDY3OCwwLDApIgogICAgIGlkPSJyZWN0OTM3Mi01LTYtNDQtNy03LTctNC0wIgogICAgIHN0eWxlPSJmaWxsOiM1NTU1NTU7ZmlsbC1vcGFjaXR5OjE7c3Ryb2tlOm5vbmUiIC8+Cjwvc3ZnPgo=);background-image:-moz-linear-gradient(transparent,transparent),url(//bits.wikimedia.org/static-1.23wmf10/extensions/UniversalLanguageSelector/lib/jquery.uls/css/../images/clear.svg?2014-01-09T16:51:40Z)!ie;background-image:linear-gradient(transparent,transparent),url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9Im5vIj8+CjwhLS0gQ3JlYXRlZCB3aXRoIElua3NjYXBlIChodHRwOi8vd3d3Lmlua3NjYXBlLm9yZy8pIC0tPgoKPHN2ZwogICB4bWxuczpkYz0iaHR0cDovL3B1cmwub3JnL2RjL2VsZW1lbnRzLzEuMS8iCiAgIHhtbG5zOmNjPSJodHRwOi8vY3JlYXRpdmVjb21tb25zLm9yZy9ucyMiCiAgIHhtbG5zOnJkZj0iaHR0cDovL3d3dy53My5vcmcvMTk5OS8wMi8yMi1yZGYtc3ludGF4LW5zIyIKICAgeG1sbnM6c3ZnPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIKICAgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIgogICB2ZXJzaW9uPSIxLjEiCiAgIHdpZHRoPSIxMi41MjA0NzUiCiAgIGhlaWdodD0iMTIuNTIwNDciCiAgIGlkPSJzdmcyIj4KICA8ZGVmcwogICAgIGlkPSJkZWZzNCIgLz4KICA8bWV0YWRhdGEKICAgICBpZD0ibWV0YWRhdGE3Ij4KICAgIDxyZGY6UkRGPgogICAgICA8Y2M6V29yawogICAgICAgICByZGY6YWJvdXQ9IiI+CiAgICAgICAgPGRjOmZvcm1hdD5pbWFnZS9zdmcreG1sPC9kYzpmb3JtYXQ+CiAgICAgICAgPGRjOnR5cGUKICAgICAgICAgICByZGY6cmVzb3VyY2U9Imh0dHA6Ly9wdXJsLm9yZy9kYy9kY21pdHlwZS9TdGlsbEltYWdlIiAvPgogICAgICAgIDxkYzp0aXRsZT48L2RjOnRpdGxlPgogICAgICA8L2NjOldvcms+CiAgICA8L3JkZjpSREY+CiAgPC9tZXRhZGF0YT4KICA8cmVjdAogICAgIHdpZHRoPSIxLjY4ODQwNzMiCiAgICAgaGVpZ2h0PSIxNi4wMTgxODgiCiAgICAgeD0iLTAuODQ0MTkwNDgiCiAgICAgeT0iMC44NDQyMTY3NiIKICAgICB0cmFuc2Zvcm09Im1hdHJpeCgwLjcwNzEwNjc4LC0wLjcwNzEwNjc4LDAuNzA3MTA2NzgsMC43MDcxMDY3OCwwLDApIgogICAgIGlkPSJyZWN0OTM3Mi01LTYtNDQtNy03LTctNCIKICAgICBzdHlsZT0iZmlsbDojNTU1NTU1O2ZpbGwtb3BhY2l0eToxO3N0cm9rZTpub25lIiAvPgogIDxyZWN0CiAgICAgd2lkdGg9IjEuNjg4NDA3MyIKICAgICBoZWlnaHQ9IjE2LjAxODE4OCIKICAgICB4PSI4LjAwOTEwMjgiCiAgICAgeT0iLTguMDA5MDgwOSIKICAgICB0cmFuc2Zvcm09Im1hdHJpeCgwLjcwNzEwNjc4LDAuNzA3MTA2NzgsLTAuNzA3MTA2NzgsMC43MDcxMDY3OCwwLDApIgogICAgIGlkPSJyZWN0OTM3Mi01LTYtNDQtNy03LTctNC0wIgogICAgIHN0eWxlPSJmaWxsOiM1NTU1NTU7ZmlsbC1vcGFjaXR5OjE7c3Ryb2tlOm5vbmUiIC8+Cjwvc3ZnPgo=);background-image:linear-gradient(transparent,transparent),url(//bits.wikimedia.org/static-1.23wmf10/extensions/UniversalLanguageSelector/lib/jquery.uls/css/../images/clear.svg?2014-01-09T16:51:40Z)!ie;cursor:pointer;height:32px;position:absolute;width:32px;margin-left:-32px}.uls-menu .filterinput{position:absolute;top:0;left:0;font-size:14px;height:32px;width:100%;text-align:left}.uls-menu .filtersuggestion{padding:6px;background-color:white;color:#888;border:1px transparent;border-radius:2px 2px 2px 2px;box-shadow:0 1px 2px transparent inset;left:1px}.uls-menu .search-input-block{position:relative}.uls-lcd-region-section ul li:hover{background-color:#eaeff7}.uls-lcd-region-section{margin-top:10px} .uls-language-list{height:17em;overflow:auto;width:auto}.uls-language-block ul{margin:0 0 1.5em}.uls-language-list ul li{cursor:pointer;font-weight:normal;overflow:hidden;white-space:nowrap; text-overflow:ellipsis; text-align:left; list-style-image:none;list-style-type:none}.uls-language-list strong{text-decoration:underline}.uls-language-list a{font-weight:normal;text-decoration:none;color:#3366bb;font-size:14px;line-height:1.6em}.uls-language-block{width:100%}.uls-no-results-view{color:#555;height:100%}.uls-no-found-more{font-size:0.9em;background:#F8F8F8;width:100%;margin-top:1.6em;line-height:1.6em;position:absolute;bottom:0;left:0}.uls-no-found-more a{cursor:pointer}\n/* cache key: enwiki:resourceloader:filter:minify-css:7:926d8d76406969fd6505077e20f27fe4 */"
]},{});mw.loader.implement("jquery.uls.data",function(){(function($){'use strict';$.uls=$.uls||{};$.uls.data={"languages":{"aa":["Latn",["AF"],"Qafár af"],"ab":["Cyrl",["EU"],"Аҧсшәа"],"ace":["Latn",["AS","PA"],"Acèh"],"ady":["Cyrl",["EU","ME"],"Адыгэбзэ"],"ady-cyrl":["ady"],"ady-latn":["Latn",["EU","ME"],"Adygabze"],"aeb":["Arab",["AF"],"زَوُن"],"af":["Latn",["AF"],"Afrikaans"],"ahr":["Deva",["AS"],"अहिराणी"],"ak":["Latn",["AF"],"Akan"],"akz":["Latn",["AM"],"Albaamo innaaɬiilka"],"aln":["Latn",["EU"],"Gegë"],"am":["Ethi",["AF"],"አማርኛ"],"an":["Latn",["EU"],"aragonés"],"ang":["Latn",["EU"],"Ænglisc"],"anp":["Deva",["AS"],"अङ्गिका"],"ar":["Arab",["ME"],"العربية"],"arc":["Syrc",["ME"],"ܐܪܡܝܐ"],"arn":["Latn",["AM"],"mapudungun"],"aro":["Latn",["AM"],"Araona"],"arq":["Latn",["AF"],"Dziri"],"ary":["Latn",["ME"],"Maġribi"],"arz":["Arab",["ME"],"مصرى"],"as":["Beng",["AS"],"অসমীয়া"],"ase":["Sgnw",["AM"]
,"American sign language"],"ast":["Latn",["EU"],"asturianu"],"av":["Cyrl",["EU"],"авар"],"avk":["Latn",["WW"],"Kotava"],"ay":["Latn",["AM"],"Aymar aru"],"az":["az-latn"],"az-latn":["Latn",["EU","ME"],"azərbaycanca"],"az-arab":["Arab",["EU","ME"],"آذربايجانجا"],"az-cyrl":["Latn",["EU","ME"],"азәрбајҹанҹа"],"azb":["az-arab"],"ba":["Cyrl",["EU"],"башҡортса"],"bar":["Latn",["EU"],"Boarisch"],"bat-smg":["sgs"],"bbc-latn":["Latn",["AS"],"Batak Toba"],"bbc-batk":["Batk",["AS"],"Batak Toba"],"bbc":["Latn",["AS"],"Batak Toba"],"bcc":["Arab",["AS","ME"],"بلوچی مکرانی"],"bcl":["Latn",["AS"],"Bikol Central"],"be-tarask":["Cyrl",["EU"],"беларуская (тарашкевіца)"],"be-x-old":["be-tarask"],"be":["Cyrl",["EU"],"беларуская"],"bew":["Latn",["AS"],"Bahasa Betawi"],"bfq":["Taml",["AS"],"படகா"],"bg":["Cyrl",["EU"],"български"],"bh":["Deva",["AS"],"भोजपुरी"],"bho":["Deva",["AS"],
"भोजपुरी"],"bi":["Latn",["PA"],"Bislama"],"bjn":["Latn",["AS"],"Bahasa Banjar"],"bm":["Latn",["AF"],"bamanankan"],"bn":["Beng",["AS"],"বাংলা"],"bo":["Tibt",["AS"],"བོད་ཡིག"],"bpy":["Beng",["AS"],"বিষ্ণুপ্রিয়া মণিপুরী"],"bqi":["Arab",["ME"],"بختياري"],"br":["Latn",["EU"],"brezhoneg"],"brh":["Latn",["ME","AS"],"Bráhuí"],"brx":["Deva",["AS"],"बड़ो"],"bs":["Latn",["EU"],"bosanski"],"bto":["Latn",["AS"],"Iriga Bicolano"],"bug":["Bugi",["AS"],"ᨅᨔ ᨕᨘᨁᨗ"],"bxr":["Cyrl",["AS"],"буряад"],"ca":["Latn",["EU"],"català"],"cbk-zam":["Latn",["AS"],"Chavacano de Zamboanga"],"cdo":["Latn",["AS"],"Mìng-dĕ̤ng-ngṳ̄"],"ce":["Cyrl",["EU"],"нохчийн"],"ceb":["Latn",["AS"],"Cebuano"],"ch":["Latn",["PA"],"Chamoru"],"cho":["Latn",["AM"],"Choctaw"],"chr":["Cher",["AM"],"ᏣᎳᎩ"],"chy":["Latn",["AM"],"Tsetsêhestâhese"],"ckb":["Arab",["ME"],"کوردی"],"co":["Latn",["EU"],"corsu"],
"cps":["Latn",["AS"],"Capiceño"],"cr":["Cans",["AM"],"ᓀᐦᐃᔭᐍᐏᐣ"],"cr-cans":["cr"],"cr-latn":["Latn",["AM"],"Nēhiyawēwin"],"crh":["Latn",["EU"],"qırımtatarca"],"crh-cyrl":["Cyrl",["EU"],"къырымтатарджа"],"crh-latn":["crh"],"cs":["Latn",["EU"],"česky"],"csb":["Latn",["EU"],"kaszëbsczi"],"cu":["Cyrl",["EU"],"словѣньскъ \/ ⰔⰎⰑⰂⰡⰐⰠⰔⰍⰟ"],"cv":["Cyrl",["EU"],"Чӑвашла"],"cy":["Latn",["EU"],"Cymraeg"],"da":["Latn",["EU"],"dansk"],"de-at":["Latn",["EU"],"Österreichisches Deutsch"],"de-ch":["Latn",["EU"],"Schweizer Hochdeutsch"],"de-formal":["Latn",["EU"],"Deutsch (Sie-Form)"],"de":["Latn",["EU"],"Deutsch"],"diq":["Latn",["EU","AS"],"Zazaki"],"dsb":["Latn",["EU"],"dolnoserbski"],"dtp":["Latn",["AS"],"Dusun Bundu-liwan"],"dv":["Thaa",["AS"],"ދިވެހިބަސް"],"dz":["Tibt",["AS"],"ཇོང་ཁ"],"ee":["Latn",["AF"],"eʋegbe"],"egl":["Latn",["EU"],"Emiliàn"],"el":["Grek",["EU"],"Ελληνικά"],"eml":["Latn",["EU"],
"emiliàn e rumagnòl"],"en-ca":["Latn",["AM"],"Canadian English"],"en-gb":["Latn",["EU","AS","PA"],"British English"],"en":["Latn",["EU","AM","AF","ME","AS","PA","WW"],"English"],"eo":["Latn",["WW"],"Esperanto"],"es-419":["Latn",["AM"],"español de America Latina"],"es-formal":["Latn",["EU","AM","AF","WW"],"español (formal)"],"es":["Latn",["EU","AM","AF","WW"],"español"],"esu":["Latn",["AM"],"Yup'ik"],"et":["Latn",["EU"],"eesti"],"eu":["Latn",["EU"],"euskara"],"ext":["Latn",["EU"],"estremeñu"],"fa":["Arab",["ME"],"فارسی"],"ff":["Latn",["AF"],"Fulfulde"],"fi":["Latn",["EU"],"suomi"],"fil":["tl"],"fit":["Latn",["EU"],"meänkieli"],"fiu-vro":["vro"],"fj":["Latn",["PA"],"Na Vosa Vakaviti"],"fo":["Latn",["EU"],"føroyskt"],"fr":["Latn",["EU","AM","WW"],"français"],"frc":["Latn",["AM"],"français cadien"],"frp":["Latn",["EU"],"arpetan"],"frr":["Latn",["EU"],"Nordfriisk"],"fur":["Latn",["EU"],"furlan"],"fy":["Latn",["EU"],"Frysk"],"ga":["Latn",["EU"],"Gaeilge"],"gag":["Latn",["EU"],
"Gagauz"],"gah":["Latn",["AS"],"Alekano"],"gan-hans":["Hans",["AS"],"赣语（简体）"],"gan-hant":["gan"],"gan":["Hant",["AS"],"贛語"],"gbz":["Latn",["AS"],"Dari"],"gcf":["Latn",["AM"],"Guadeloupean Creole French"],"gd":["Latn",["EU"],"Gàidhlig"],"gl":["Latn",["EU"],"galego"],"glk":["Arab",["ME"],"گیلکی"],"gn":["Latn",["AM"],"Avañe'ẽ"],"gom":["Deva",["AS"],"कोंकणी"],"gom-deva":["gom"],"gom-latn":["Latn",["AS"],"Konknni"],"got":["Goth",["EU"],"𐌲𐌿𐍄𐌹𐍃𐌺"],"grc":["Grek",["EU"],"Ἀρχαία ἑλληνικὴ"],"gsw":["Latn",["EU"],"Alemannisch"],"gu":["Gujr",["AS"],"ગુજરાતી"],"guc":["Latn",["AM"],"Wayúu"],"gur":["Latn",["AF"],"Gurenɛ"],"gv":["Latn",["EU"],"Gaelg"],"ha-arab":["Arab",["AF"],"هَوُسَ"],"ha-latn":["Latn",["AF"],"Hausa"],"ha":["ha-latn"],"hak":["Latn",["AS"],"Hak-kâ-fa"],"haw":["Latn",["AM","PA"],"Hawai`i"],"he":["Hebr",["ME"],"עברית"],"hi":["Deva",["AS"],"हिन्दी"],"hif":["Latn",["PA","AS"],
"Fiji Hindi"],"hif-deva":["Deva",["AS"],"फ़ीजी हिन्दी"],"hif-latn":["hif"],"hil":["Latn",["AS"],"Ilonggo"],"hne":["Deva",["AS"],"छत्तीसगढ़ी"],"ho":["Latn",["PA"],"Hiri Motu"],"hr":["Latn",["EU"],"hrvatski"],"hsb":["Latn",["EU"],"hornjoserbsce"],"hsn":["Hans",["AS"],"湘语"],"ht":["Latn",["AM"],"Kreyòl ayisyen"],"hu-formal":["Latn",["EU"],"Magyar (magázó)"],"hu":["Latn",["EU"],"magyar"],"hy":["Armn",["EU","ME"],"Հայերեն"],"hz":["Latn",["AF"],"Otsiherero"],"ia":["Latn",["WW"],"interlingua"],"id":["Latn",["AS"],"Bahasa Indonesia"],"ie":["Latn",["WW"],"Interlingue"],"ig":["Latn",["AF"],"Igbo"],"ii":["Yiii",["AS"],"ꆇꉙ"],"ik":["Latn",["AM"],"Iñupiak"],"ike-cans":["Cans",["AM"],"ᐃᓄᒃᑎᑐᑦ"],"ike-latn":["Latn",["AM"],"inuktitut"],"ilo":["Latn",["AS"],"Ilokano"],"inh":["Cyrl",["EU"],"ГӀалгӀай"],"io":["Latn",["WW"],"Ido"],"is":["Latn",["EU"],"íslenska"],"it":["Latn",["EU"],"italiano"],"iu":["Cans",["AM"],
"ᐃᓄᒃᑎᑐᑦ"],"ja":["Jpan",["AS"],"日本語"],"jam":["Latn",["AM"],"Patois"],"jbo":["Latn",["WW"],"Lojban"],"jut":["Latn",["EU"],"jysk"],"jv":["Latn",["AS","PA"],"Basa Jawa"],"jv-java":["Java",["AS","PA"],"ꦧꦱꦗꦮ"],"ka":["Geor",["EU"],"ქართული"],"kaa":["Latn",["AS"],"Qaraqalpaqsha"],"kab":["Latn",["AF","EU"],"Taqbaylit"],"kbd-cyrl":["kbd"],"kbd-latn":["Latn",["EU"],"Qabardjajəbza"],"kbd":["Cyrl",["EU","ME"],"Адыгэбзэ"],"kea":["Latn",["AF"],"Kabuverdianu"],"kg":["Latn",["AF"],"Kongo"],"kgp":["Latn",["AM"],"Kaingáng"],"khw":["Arab",["ME","AS"],"کھوار"],"ki":["Latn",["AF"],"Gĩkũyũ"],"kiu":["Latn",["EU","ME"],"Kırmancki"],"kj":["Latn",["AF"],"Kwanyama"],"kk":["kk-cyrl"],"kk-arab":["Arab",["EU","AS"],"قازاقشا (تٶتە)"],"kk-cn":["kk-arab"],"kk-cyrl":["Cyrl",["EU","AS"],"қазақша"],"kk-kz":["kk-cyrl"],"kk-latn":["Latn",["EU","AS","ME"],"qazaqşa"],"kk-tr":["kk-latn"],"kl":["Latn",["AM","EU"],"kalaallisut"],"km":["Khmr",["AS"],
"ភាសាខ្មែរ"],"kn":["Knda",["AS"],"ಕನ್ನಡ"],"ko-kp":["Kore",["AS"],"한국어 (조선)"],"ko":["Kore",["AS"],"한국어"],"koi":["Cyrl",["EU"],"Перем Коми"],"kr":["Latn",["AF"],"Kanuri"],"krc":["Cyrl",["EU"],"къарачай-малкъар"],"kri":["Latn",["AF"],"Krio"],"krj":["Latn",["ME","EU"],"Kinaray-a"],"krl":["Latn",["EU"],"Karjala"],"ks-arab":["Arab",["AS"],"کٲشُر"],"ks-deva":["Deva",["AS"],"कॉशुर"],"ks":["Arab",["AS"],"کٲشُر"],"ksf":["Latn",["AF"],"Bafia"],"ksh":["Latn",["EU"],"Ripoarisch"],"ku":["ku-latn"],"ku-arab":["Arab",["EU","ME"],"كوردي"],"ku-latn":["Latn",["EU","ME"],"Kurdî"],"kv":["Cyrl",["EU"],"коми"],"kw":["Latn",["EU"],"kernowek"],"ky":["Cyrl",["AS"],"Кыргызча"],"la":["Latn",["EU"],"Latina"],"lad":["lad-latn"],"lad-latn":["Latn",["ME","EU","AM"],"Ladino"],"lad-hebr":["Hebr",["ME","EU","AM"],"לאדינו"],"lb":["Latn",["EU"],"Lëtzebuergesch"],"lbe":["Cyrl",["EU"],"лакку"],"lez":["Cyrl",
["EU"],"лезги"],"lfn":["Latn",["WW"],"Lingua Franca Nova"],"lg":["Latn",["AF"],"Luganda"],"li":["Latn",["EU"],"Limburgs"],"lij":["Latn",["EU"],"Ligure"],"liv":["Latn",["EU"],"Līvõ kēļ"],"lld":["Latn",["EU"],"Ladin"],"lmo":["Latn",["EU"],"lumbaart"],"ln":["Latn",["AF"],"lingála"],"lo":["Laoo",["AS"],"ລາວ"],"loz":["Latn",["AF"],"Silozi"],"lt":["Latn",["EU"],"lietuvių"],"lrc":["Arab",["AS"],"لوری"],"ltg":["Latn",["EU"],"latgaļu"],"lus":["Latn",["AS"],"Mizo ţawng"],"lv":["Latn",["EU"],"latviešu"],"lzh":["Hant",["AS"],"文言"],"lzz":["Latn",["EU","ME"],"Lazuri"],"mai":["Deva",["AS"],"मैथिली"],"map-bms":["Latn",["AS"],"Basa Banyumasan"],"mdf":["Cyrl",["EU"],"мокшень"],"mfe":["Latn",["AM"],"Morisyen"],"mg":["Latn",["AF"],"Malagasy"],"mh":["Latn",["PA"],"Ebon"],"mhr":["Cyrl",["EU"],"олык марий"],"mi":["Latn",["PA"],"Māori"],"mic":["Latn",["AM"],"Mi'kmaq"],"min":["Latn",["AS"],"Baso Minangkabau"],"mk":["Cyrl",["EU"],"македонски"],
"ml":["Mlym",["AS","ME"],"മലയാളം"],"mn":["Cyrl",["AS"],"монгол"],"mnc":["Mong",["AS"],"ᠮᠠᠨᠵᡠ ᡤᡳᠰᡠᠨ"],"mni":["Beng",["AS"],"মেইতেই লোন্"],"mnw":["Mymr",["AS"],"ဘာသာ မန်"],"mo":["Cyrl",["EU"],"молдовеняскэ"],"mr":["Deva",["AS","ME"],"मराठी"],"mrj":["Cyrl",["EU"],"кырык мары"],"ms":["Latn",["AS"],"Bahasa Melayu"],"mt":["Latn",["EU"],"Malti"],"mui":["Latn",["AS"],"Musi"],"mus":["Latn",["AM"],"Mvskoke"],"mwl":["Latn",["EU"],"Mirandés"],"mwv":["Latn",["AS"],"Behase Mentawei"],"my":["Mymr",["AS"],"မြန်မာဘာသာ"],"myv":["Cyrl",["EU"],"эрзянь"],"mzn":["Arab",["ME","AS"],"مازِرونی"],"na":["Latn",["PA"],"Dorerin Naoero"],"nah":["Latn",["AM"],"Nāhuatl"],"nan":["Latn",["AS"],"Bân-lâm-gú"],"nap":["Latn",["EU"],"Nnapulitano"],"nb":["Latn",["EU"],"norsk (bokmål)"],"nds-nl":["Latn",["EU"],"Nedersaksisch"],"nds":["Latn",["EU"],"Plattdüütsch"],"ne":["Deva",["AS"],
"नेपाली"],"new":["Deva",["AS"],"नेपाल भाषा"],"ng":["Latn",["AF"],"Oshiwambo"],"niu":["Latn",["PA"],"ko e vagahau Niuē"],"njo":["Latn",["AS"],"Ao"],"nl-informal":["Latn",["EU","AM"],"Nederlands (informeel)"],"nl":["Latn",["EU","AM"],"Nederlands"],"nn":["Latn",["EU"],"norsk (nynorsk)"],"no":["Latn",["EU"],"norsk"],"nov":["Latn",["WW"],"Novial"],"nqo":["Nkoo",["AF"],"ߒߞߏ"],"nrm":["Latn",["EU"],"Nouormand"],"nso":["Latn",["AF"],"Sesotho sa Leboa"],"nv":["Latn",["AM"],"Diné bizaad"],"ny":["Latn",["AF"],"Chi-Chewa"],"oc":["Latn",["EU"],"occitan"],"om":["Latn",["AF"],"Oromoo"],"or":["Orya",["AS"],"ଓଡ଼ିଆ"],"os":["Cyrl",["EU"],"Ирон"],"pa":["pa-guru"],"pa-guru":["Guru",["AS"],"ਪੰਜਾਬੀ"],"pag":["Latn",["AS"],"Pangasinan"],"pam":["Latn",["AS"],"Kapampangan"],"pap":["Latn",["AM"],"Papiamentu"],"pcd":["Latn",["EU"],"Picard"],"pdc":["Latn",["EU","AM"],"Deitsch"],"pdt":["Latn",["EU","AM"],"Plautdietsch"],"pfl":["Latn",["EU"],"Pälzisch"],
"pi":["Deva",["AS"],"पालि"],"pih":["Latn",["PA"],"Norfuk \/ Pitkern"],"pis":["Latn",["PA"],"Pijin"],"pko":["Latn",["AF"],"Pökoot"],"pl":["Latn",["EU"],"polski"],"pms":["Latn",["EU"],"Piemontèis"],"pnb":["Arab",["AS","ME"],"پنجابی"],"pnt":["Grek",["EU"],"Ποντιακά"],"ppl":["Latn",["AM"],"Nawat"],"prg":["Latn",["EU"],"Prūsiskan"],"ps":["Arab",["AS","ME"],"پښتو"],"pt-br":["Latn",["AM"],"português do Brasil"],"pt":["Latn",["EU","AM","AS","PA","AF","WW"],"português"],"qu":["Latn",["AM"],"Runa Simi"],"qug":["Latn",["AM"],"Runa shimi"],"rap":["Latn",["AM"],"arero rapa nui"],"rgn":["Latn",["EU"],"Rumagnôl"],"rif":["Latn",["AF"],"Tarifit"],"rki":["Mymr",["AS"],"ရခိုင်"],"rm":["Latn",["EU"],"rumantsch"],"rmy":["Latn",["EU"],"Romani"],"rn":["Latn",["AF"],"Kirundi"],"ro":["Latn",["EU"],"română"],"roa-rup":["rup"],"roa-tara":["Latn",["EU"],"tarandíne"],"rtm":["Latn",["PA"],"Faeag Rotuma"],"ru":["Cyrl",["EU","AS","ME"],"русский"],"rue":["Cyrl",[
"EU"],"русиньскый"],"rup":["Latn",["EU"],"Armãneashce"],"ruq":["Cyrl",["EU"],"Влахесте"],"ruq-cyrl":["ruq"],"ruq-grek":["Grek",["EU"],"Megleno-Romanian (Greek script)"],"ruq-latn":["Latn",["EU"],"Vlăheşte"],"rw":["Latn",["AF"],"Kinyarwanda"],"ryu":["Kana",["AS"],"ʔucināguci"],"sa":["Deva",["AS"],"संस्कृतम्"],"sah":["Cyrl",["EU","AS"],"саха тыла"],"sat":["Latn",["AS"],"Santali"],"saz":["Saur",["AS"],"ꢱꣃꢬꢵꢯ꣄ꢡ꣄ꢬꢵ"],"sc":["Latn",["EU"],"sardu"],"scn":["Latn",["EU"],"sicilianu"],"sco":["Latn",["EU"],"Scots"],"sd":["Arab",["AS"],"سنڌي"],"sdc":["Latn",["EU"],"Sassaresu"],"se":["Latn",["EU"],"sámegiella"],"ses":["Latn",["AF"],"Koyraboro Senni"],"sei":["Latn",["AM"],"Cmique Itom"],"sg":["Latn",["AF"],"Sängö"],"sgs":["Latn",["EU"],"žemaitėška"],"sh":["Latn",["EU"],"srpskohrvatski"],"shi-latn":["Latn",["AF"],"Tašlḥiyt"],"shi-tfng":["Tfng",["AF"],"ⵜⴰⵛⵍⵃⵉⵜ"],"shi":["shi-latn"],"shn":["Mymr",["AS"],
"လိၵ်ႈတႆး"],"si":["Sinh",["AS"],"සිංහල"],"simple":["Latn",["WW"],"Simple English"],"sk":["Latn",["EU"],"slovenčina"],"sl":["Latn",["EU"],"slovenščina"],"sli":["Latn",["EU"],"Schläsch"],"slr":["Latn",["AS"],"Salırça"],"sly":["Latn",["AS"],"Bahasa Selayar"],"syc":["Syrc",["ME"],"ܣܘܪܝܝܐ"],"sm":["Latn",["PA"],"Gagana Samoa"],"sma":["Latn",["EU"],"åarjelsaemien"],"smj":["Latn",["EU"],"julevsámegiella"],"smn":["Latn",["EU"],"anarâškielâ"],"sms":["Latn",["EU"],"sää´mǩiõll"],"sn":["Latn",["AF"],"chiShona"],"so":["Latn",["AF"],"Soomaaliga"],"sq":["Latn",["EU"],"shqip"],"sr":["sr-cyrl"],"sr-ec":["sr-cyrl"],"sr-cyrl":["Cyrl",["EU"],"српски"],"sr-el":["sr-latn"],"sr-latn":["Latn",["EU"],"srpski"],"srn":["Latn",["AM","EU"],"Sranantongo"],"ss":["Latn",["AF"],"SiSwati"],"st":["Latn",["AF"],"Sesotho"],"stq":["Latn",["EU"],"Seeltersk"],"su":["Latn",["AS"],"Basa Sunda"],"sv":["Latn",["EU"],"svenska"],"sw":["Latn",["AF"],"Kiswahili"],"swb":["Latn",[
"AF"],"Shikomoro"],"sxu":["Latn",["EU"],"Säggssch"],"szl":["Latn",["EU"],"ślůnski"],"ta":["Taml",["AS"],"தமிழ்"],"tcy":["Knda",["AS"],"ತುಳು"],"te":["Telu",["AS"],"తెలుగు"],"tet":["Latn",["AS","PA"],"tetun"],"tg-cyrl":["Cyrl",["AS"],"тоҷикӣ"],"tg-latn":["Latn",["AS"],"tojikī"],"tg":["Cyrl",["AS"],"тоҷикӣ"],"th":["Thai",["AS"],"ไทย"],"ti":["Ethi",["AF"],"ትግርኛ"],"tk":["Latn",["AS"],"Türkmençe"],"tkr":["Cyrl",["AS"],"ЦӀаьхна миз"],"tl":["Latn",["AS"],"Tagalog"],"tly":["Cyrl",["EU","AS","ME"],"толышә зывон"],"tn":["Latn",["AF"],"Setswana"],"to":["Latn",["PA"],"lea faka-Tonga"],"tokipona":["Latn",["WW"],"Toki Pona"],"tpi":["Latn",["PA","AS"],"Tok Pisin"],"tr":["Latn",["EU","ME"],"Türkçe"],"trp":["Latn",["AS"],"Kokborok (Tripuri)"],"tru":["Latn",["AS"],"Ṫuroyo"],"ts":["Latn",["AF"],"Xitsonga"],"tsd":["Grek",["EU"],"Τσακωνικά"],"tt":["Cyrl",["EU"],"татарча"],"tt-cyrl":["tt"],"tt-latn":["Latn"
,["EU"],"tatarça"],"ttt":["Cyrl",["AS"],"Tati"],"tum":["Latn",["AF"],"chiTumbuka"],"tw":["Latn",["AF"],"Twi"],"twd":["Latn",["EU"],"Tweants"],"ty":["Latn",["PA"],"Reo Mā`ohi"],"tyv":["Cyrl",["AS"],"тыва дыл"],"tzm":["Tfng",["AF"],"ⵜⴰⵎⴰⵣⵉⵖⵜ"],"udm":["Cyrl",["EU"],"удмурт"],"ug":["ug-arab"],"ug-arab":["Arab",["AS"],"ئۇيغۇرچە"],"ug-latn":["Latn",["AS"],"uyghurche"],"ug-cyrl":["Cyrl",["AS"],"уйғурчә"],"uk":["Cyrl",["EU"],"українська"],"ur":["Arab",["AS","ME"],"اردو"],"uz":["Latn",["AS"],"oʻzbekcha"],"ve":["Latn",["AF"],"Tshivenda"],"vec":["Latn",["EU"],"vèneto"],"vep":["Latn",["EU"],"vepsän kel’"],"vi":["Latn",["AS"],"Tiếng Việt"],"vls":["Latn",["EU"],"West-Vlams"],"vmf":["Latn",["EU"],"Mainfränkisch"],"vo":["Latn",["WW"],"Volapük"],"vot":["Latn",["EU"],"Vaďďa"],"vro":["Latn",["EU"],"Võro"],"wa":["Latn",["EU"],"walon"],"war":["Latn",["AS"],"Winaray"],"wls":["Latn",["PA"],"Faka'uvea"],"wo":["Latn",["AF"],"Wolof"],
"wuu":["Hans",["AS"],"吴语"],"xal":["Cyrl",["EU"],"хальмг"],"xh":["Latn",["AF"],"isiXhosa"],"xmf":["Geor",["EU"],"მარგალური"],"ydd":["Hebr",["AS","EU"],"Eastern Yiddish"],"yi":["Hebr",["ME","EU","AM"],"ייִדיש"],"yo":["Latn",["AF"],"Yorùbá"],"yrk":["Cyrl",["AS"],"Ненэцяʼ вада"],"yrl":["Latn",["AM"],"ñe'engatú"],"yua":["Latn",["AM"],"Maaya T'aan"],"yue":["Hant",["AS"],"粵語"],"za":["Latn",["AS"],"Vahcuengh"],"zea":["Latn",["EU"],"Zeêuws"],"zh":["Hans",["AS"],"中文"],"zh-classical":["Hant",["AS"],"文言"],"zh-cn":["Hans",["AS"],"中文（中国大陆）"],"zh-hans":["Hans",["AS"],"中文（简体）"],"zh-hant":["Hant",["AS"],"中文（繁體）"],"zh-hk":["Hant",["AS"],"中文（香港）"],"zh-min-nan":["nan"],"zh-mo":["Hant",["AS"],"中文（澳門）"],"zh-my":["Hans",["AS"],"中文（马来西亚）"],"zh-sg":["Hans",["AS"],"中文（新加坡）"],"zh-tw":["Hant",["AS"],"中文（台灣）"],"zh-yue":["yue"],"zu":["Latn",["AF"],
"isiZulu"]},"scriptgroups":{"Latin":["Latn","Goth"],"Greek":["Grek"],"WestCaucasian":["Armn","Geor"],"Arabic":["Arab"],"MiddleEastern":["Hebr","Syrc"],"African":["Ethi","Nkoo","Tfng"],"SouthAsian":["Beng","Deva","Gujr","Guru","Knda","Mlym","Orya","Saur","Sinh","Taml","Telu","Tibt","Thaa"],"Cyrillic":["Cyrl"],"CJK":["Hans","Hant","Kana","Kore","Jpan","Yiii"],"SouthEastAsian":["Batk","Bugi","Java","Khmr","Laoo","Mymr","Thai"],"Mongolian":["Mong"],"SignWriting":["Sgnw"],"NativeAmerican":["Cher","Cans"],"Special":["Zyyy"]},"rtlscripts":["Arab","Hebr","Syrc","Nkoo","Thaa"],"regiongroups":{"WW":1,"SP":1,"AM":2,"EU":3,"ME":3,"AF":3,"AS":4,"PA":4},"territories":{"AC":["en"],"AD":["ca","es","fr"],"AE":["ar","ml","ps","bal","fa"],"AF":["fa","ps","haz","uz-arab","tk-latn","prd","bal","ug-arab","kk-arab"],"AG":["en","pt"],"AI":["en"],"AL":["sq","el","mk"],"AM":["hy","az-latn","ku-latn"],"AO":["pt","umb","kmb","ln"],"AQ":["und"],"AR":["es","cy","gn"],"AS":["sm","en"],"AT":["de","hr","sl","hu"],"AU"
:["en","zh-hant","it"],"AW":["nl","pap","en"],"AX":["sv"],"AZ":["az-latn","az-cyrl","ku-latn"],"BA":["bs-cyrl","bs-latn","hr","sr-cyrl","sr-latn"],"BB":["en"],"BD":["bn","rkt","syl","ccp","my","grt","mni"],"BE":["nl","en","fr","wa","de"],"BF":["mos","dyu","fr"],"BG":["bg","tr"],"BH":["ar","ml"],"BI":["rn","fr","sw"],"BJ":["fr","fon","yo"],"BL":["fr"],"BM":["en"],"BN":["ms-latn","zh-hant","ms-arab","en"],"BO":["es","qu","ay","gn"],"BQ":["pap","nl"],"BR":["pt","de","it","ja","ko","kgp","gub","xav"],"BS":["en"],"BT":["dz","ne","tsj","lep"],"BV":["und"],"BW":["en","tn","af"],"BY":["be","ru"],"BZ":["en","es"],"CA":["en","fr","it","de","cr-cans","crk","yi","iu","moe","crj","atj","crl","csw","crm","ikt","dgr","den","scs","nsk","chp","gwi"],"CC":["ms-arab","en"],"CD":["sw","lua","fr","ln","lu","kg","lol","rw"],"CF":["fr","sg","ln"],"CG":["fr","ln"],"CH":["de","fr","gsw","it","lmo","rm","rmo","wae"],"CI":["fr","bci","sef","daf","kfo","bqv"],"CK":["en"],"CL":["es"],"CM":["fr","en","bum","ff",
"ewo","ybb","bbj","nnh","bkm","bas","bax","byv","mua","maf","bfd","bss","kkj","dua","ar","ksf","agq","ha-arab","nmg","yav"],"CN":["zh-hans","ii","ug-arab","za","mn-mong","bo","ko","kk-arab","lis","ky-arab","nbf","khb","tdd","lcp","en","ru","vi","uz-cyrl"],"CO":["es"],"CP":["und"],"CR":["es"],"CU":["es"],"CV":["kea","pt"],"CW":["pap","nl","es"],"CX":["en"],"CY":["el","tr","hy","ar"],"CZ":["cs","de","pl"],"DE":["de","en","nds","tr","hr","it","ku-latn","ru","el","ksh","pl","es","nl","da","dsb"],"DG":["en"],"DJ":["aa","so","ar","fr"],"DK":["da","de","kl"],"DM":["en"],"DO":["es","en"],"DZ":["ar","fr","kab"],"EA":["es"],"EC":["es"],"EE":["et","ru"],"EG":["ar","el"],"EH":["ar"],"ER":["ti","en","tig","ar","aa","ssy","byn"],"ES":["es","en","ca","gl","eu","ast"],"ET":["en","am","om","so","ti","sid","wal","aa"],"FI":["fi","sv","ru","en","et","rmf","se","smn","sms"],"FJ":["en","hi","fj"],"FK":["en"],"FM":["chk","pon","kos","yap","en","uli"],"FO":["fo"],"FR":["fr","en","oc","it","pt","gsw","br",
"co","ca","nl","eu"],"GA":["fr","puu","mdt"],"GB":["en","sco","pa-guru","cy","bn","zh-hant","syl","el","it","ks-arab","gd","yi","ml","ga","fr","kw"],"GD":["en"],"GE":["ka","ru","hy","ab","os","ku-latn"],"GF":["fr","gcr","zh-hant"],"GG":["en"],"GH":["ak","en","ee","abr","gaa","ha-latn","saf"],"GI":["en"],"GL":["kl","da"],"GM":["en","man-latn"],"GN":["fr","ff","man-nkoo","sus","kpe"],"GP":["fr"],"GQ":["es","fan","fr","bvb","syi"],"GR":["el","mk","tr","bg","sq"],"GS":["und"],"GT":["es"],"GU":["en","ch"],"GW":["pt"],"GY":["en"],"HK":["zh-hant","en","zh-hans"],"HM":["und"],"HN":["es","en"],"HR":["hr","it"],"HT":["ht","fr"],"HU":["hu","de","ro","hr","sk","sl"],"IC":["es"],"ID":["id","jv","su","mad","ms-arab","min","bya","bjn","ban","bug","ace","bew","sas","bbc","zh-hant","mak","ljp","rej","gor","nij","kge","aoz","mgy","kvr","lbw","rob","mdr","sxn"],"IE":["en","ga"],"IL":["he","ar","ru","ro","yi","en","pl","hu","am","ti","ml"],"IM":["en","gv"],"IN":["hi","en","bn","te","mr","ta","ur","gu",
"kn","ml","or","pa-guru","bho","awa","as","bgc","mag","mwr","mai","hne","dcc","bjj","ne","sat","wtm","rkt","ks-arab","kok","swv","gbm","lmn","sd-arab","gon-telu","kfy","doi","kru","sck","tcy","wbq","xnr","wbr","khn","brx","noe","bhb","mni","raj","hoc","mtr","unr-beng","bhi","hoj","kha","kfr","grt","unx-beng","bfy","srx","saz","ccp","sd-deva","bfq","ria","bo","bft","bra","lep","btv","lif-deva","lah","sa","kht","dv","dz"],"IO":["en"],"IQ":["ar","ckb","fa","syr"],"IR":["fa","az-arab","glk","ckb","tk-latn","sdh","lrc","ar","bal","rmt","bqi","luz","lki","prd","hy","ps","ka","kk-arab"],"IS":["is","da"],"IT":["it","en","nap","scn","fur","de","fr","sl","ca","el","hr"],"JE":["en"],"JM":["en"],"JO":["ar"],"JP":["ja","ryu","ko"],"KE":["en","sw","ki","luy","luo","kam","kln","guz","mer","mas","ebu","so","dav","teo","pko","om","saq","ar","pa-guru","gu"],"KG":["ky-cyrl","ru"],"KH":["km","cja","kdt"],"KI":["en","gil"],"KM":["ar","fr","zdj"],"KN":["en"],"KP":["ko"],"KR":["ko"],"KW":["ar"],"KY":["en"],
"KZ":["ru","kk-cyrl","de","ug-cyrl"],"LA":["lo","kjg","kdt"],"LB":["ar","hy","ku-arab","fr","en"],"LC":["en"],"LI":["de","gsw","wae"],"LK":["si","ta","en"],"LR":["en","kpe","vai-vaii","men"],"LS":["st","zu","ss","en","xh"],"LT":["lt","ru"],"LU":["fr","lb","de"],"LV":["lv","ru"],"LY":["ar"],"MA":["ar","zgh","fr","tzm-latn","shi-latn","shi-tfng","rif","es"],"MC":["fr"],"MD":["ro","uk","bg","gag","ru"],"ME":["sr-latn","sq","sr-cyrl"],"MF":["fr"],"MG":["mg","fr","en"],"MH":["en","mh"],"MK":["mk","sq","tr"],"ML":["bm","fr","ffm","snk","mwk","ses","tmh","khq","dtm","kao","bzx","ar","bmq","bze"],"MM":["my","shn","mnw","kht"],"MN":["mn-cyrl","kk-arab","zh-hans","ru","ug-cyrl"],"MO":["zh-hant","pt","zh-hans"],"MP":["en","ch"],"MQ":["fr"],"MR":["ar","fr","ff","wo"],"MS":["en"],"MT":["mt","en"],"MU":["mfe","en","bho","ur","fr","ta"],"MV":["dv"],"MW":["en","ny","tum","zu"],"MX":["es","yua","nhe","nhw","maz","nch"],"MY":["ms-latn","en","zh-hant","ta","bjn","jv","zmi","ml","bug"],"MZ":["pt","vmw",
"ndc","ts","ngl","seh","rng","ny","yao","sw","zu"],"NA":["af","kj","ng","naq","en","de","tn"],"NC":["fr"],"NE":["ha-latn","fr","dje","fuq","tmh","ar","twq"],"NF":["en"],"NG":["en","ha-latn","ig","yo","fuv","tiv","efi","ibb","ha-arab","bin","kaj","kcg","ar","cch","amo"],"NI":["es"],"NL":["nl","en","li","fy","gos","id","zea","rif","tr"],"NO":["nb","nn","se"],"NP":["ne","mai","bho","new","jml","taj","awa","thl","bap","tdg","thr","mgp","lif-deva","thq","mrd","bfy","xsr","rjs","tsf","hi","ggn","gvr","bo","tkt","tdh","bn","unr-deva","lep"],"NR":["en","na"],"NU":["en","niu"],"NZ":["en","mi"],"OM":["ar","bal","fa"],"PA":["es","en","zh-hant"],"PE":["es","qu","ay"],"PF":["fr","ty","zh-hant"],"PG":["tpi","en","ho"],"PH":["en","fil","es","ceb","ilo","hil","bik","war","bhk","pam","pag","mdh","tsg","zh-hant","bto","hnn","tbw","bku"],"PK":["ur","pa-arab","en","lah","ps","sd-arab","skr","bal","brh","hno","fa","hnd","tg-arab","gju","bft","kvx","khw","mvy","kxp","gjk","ks-arab","btv"],"PL":["pl","de",
"be","uk","csb","lt"],"PM":["fr","en"],"PN":["en"],"PR":["es","en"],"PS":["ar"],"PT":["pt","gl"],"PW":["pau","en"],"PY":["gn","es","de"],"QA":["ar","fa","ml"],"RE":["fr","rcf","ta"],"RO":["ro","hu","de","tr","sr-latn","bg","el","pl"],"RS":["sr-cyrl","sr-latn","sq","hu","ro","hr","sk","uk"],"RU":["ru","tt","ba","cv","ce","av","udm","chm","sah","os","kbd","myv","dar","bua","mdf","kum","kv","lez","krc","inh","tyv","az-cyrl","ady","krl","koi","lbe","mrj","alt","fi","sr-latn","mn-cyrl"],"RW":["rw","fr","en"],"SA":["ar"],"SB":["en"],"SC":["crs","fr","en"],"SD":["ar","en","ha-arab"],"SE":["sv","fi","fit","se","rmu","yi","smj","sma","ia"],"SG":["en","zh-hans","ms-latn","ta","ml","pa-guru"],"SH":["en"],"SI":["sl","hu","it"],"SJ":["nb","ru"],"SK":["sk","hu","uk","pl","de"],"SL":["kri","en","men","tem"],"SM":["it","eo"],"SN":["fr","wo","ff","srr"],"SO":["so","ar","sw","om"],"SR":["nl","srn","zh-hant"],"SS":["ar","en"],"ST":["pt"],"SV":["es"],"SX":["en","es","vic","nl"],"SY":["ar","ku-latn","fr",
"hy","syr"],"SZ":["en","ss","zu","ts"],"TA":["en"],"TC":["en"],"TD":["fr","ar"],"TF":["fr"],"TG":["fr","ee"],"TH":["th","tts","nod","sou","mfa","zh-hant","kxm","kdt","mnw","shn","lcp","lwl"],"TJ":["tg-cyrl","fa","ar"],"TK":["en","tkl"],"TL":["pt","tet"],"TM":["tk-latn","ru","uz-latn","ku-latn"],"TN":["ar","fr"],"TO":["to","en"],"TR":["tr","ku-latn","zza","kbd","az-latn","ar","bgx","bg","ady","hy","ka","sr-latn","sq","ab","el","uz-latn","ky-latn","kk-cyrl"],"TT":["en","es"],"TV":["tvl","en"],"TW":["zh-hant","trv"],"TZ":["sw","en","suk","nym","kde","bez","ksb","mas","asa","lag","jmc","rof","vun","rwk"],"UA":["uk","ru","pl","yi","rue","be","ro","bg","tr","hu","el"],"UG":["sw","lg","nyn","cgg","xog","en","teo","laj","myx","rw","ttj","hi"],"UM":["en"],"US":["en","es","zh-hant","fr","de","fil","it","vi","ko","ru","nv","yi","haw","chr","lkt","ik"],"UY":["es"],"UZ":["uz-latn","uz-cyrl","ru","kaa","tr"],"VA":["it","la"],"VC":["en"],"VE":["es"],"VG":["en"],"VI":["en"],"VN":["vi","zh-hant","cjm"]
,"VU":["bi","en","fr"],"WF":["wls","fr","fud"],"WS":["sm","en"],"XK":["sq","sr-cyrl","sr-latn"],"YE":["ar"],"YT":["swb","fr","buc","sw"],"ZA":["en","zu","xh","af","nso","tn","st","ts","ss","ve","hi","nr","sw"],"ZM":["en","bem","ny"],"ZW":["en","sn","nd","mxc","ndc","kck","ny","ve","tn"],"ZZ":[]}};}(jQuery));(function($){'use strict';$.uls.data.isRedirect=function(language){return($.uls.data.languages[language]!==undefined&&$.uls.data.languages[language].length===1)?$.uls.data.languages[language][0]:false;};$.uls.data.getScript=function(language){var target=$.uls.data.isRedirect(language);if(target){return $.uls.data.getScript(target);}if(!$.uls.data.languages[language]){return'Zyyy';}return $.uls.data.languages[language][0];};$.uls.data.getRegions=function(language){var target=$.uls.data.isRedirect(language);if(target){return $.uls.data.getRegions(target);}return($.uls.data.languages[language]&&$.uls.data.languages[language][1])||'UNKNOWN';};$.uls.data.getAutonym=function(language){var
target=$.uls.data.isRedirect(language);if(target){return $.uls.data.getAutonym(target);}return($.uls.data.languages[language]&&$.uls.data.languages[language][2])||language;};$.uls.data.getAutonyms=function(){var language,autonymsByCode={};for(language in $.uls.data.languages){if($.uls.data.isRedirect(language)){continue;}autonymsByCode[language]=$.uls.data.getAutonym(language);}return autonymsByCode;};$.uls.data.getAllRegions=function(){var region,allRegions=[];for(region in $.uls.data.regiongroups){allRegions.push(region);}return allRegions;};$.uls.data.getLanguagesInScript=function(script){return $.uls.data.getLanguagesInScripts([script]);};$.uls.data.getLanguagesInScripts=function(scripts){var language,i,languagesInScripts=[];for(language in $.uls.data.languages){if($.uls.data.isRedirect(language)){continue;}for(i=0;i<scripts.length;i++){if(scripts[i]===$.uls.data.getScript(language)){languagesInScripts.push(language);break;}}}return languagesInScripts;};$.uls.data.
getLanguagesInRegion=function(region){return $.uls.data.getLanguagesInRegions([region]);};$.uls.data.getLanguagesInRegions=function(regions){var language,i,languagesInRegions=[];for(language in $.uls.data.languages){if($.uls.data.isRedirect(language)){continue;}for(i=0;i<regions.length;i++){if($.inArray(regions[i],$.uls.data.getRegions(language))!==-1){languagesInRegions.push(language);break;}}}return languagesInRegions;};$.uls.data.getLanguagesInRegionGroup=function(groupNum){return $.uls.data.getLanguagesInRegions($.uls.data.getRegionsInGroup(groupNum));};$.uls.data.getLanguagesByScriptInRegion=function(region){var language,script,languagesByScriptInRegion={};for(language in $.uls.data.languages){if($.uls.data.isRedirect(language)){continue;}if($.inArray(region,$.uls.data.getRegions(language))!==-1){script=$.uls.data.getScript(language);if(languagesByScriptInRegion[script]===undefined){languagesByScriptInRegion[script]=[];}languagesByScriptInRegion[script].push(language);}}return languagesByScriptInRegion
;};$.uls.data.getLanguagesByScriptGroupInRegion=function(region){return $.uls.data.getLanguagesByScriptGroupInRegions([region]);};$.uls.data.getAllLanguagesByScriptGroup=function(){return $.uls.data.getLanguagesByScriptGroupInRegions($.uls.data.getAllRegions());};$.uls.data.getLanguagesByScriptGroup=function(languages){var languagesByScriptGroup={},language,codeToAdd,langScriptGroup;for(language in languages){codeToAdd=$.uls.data.isRedirect(language)||language;langScriptGroup=$.uls.data.getScriptGroupOfLanguage(codeToAdd);if(!languagesByScriptGroup[langScriptGroup]){languagesByScriptGroup[langScriptGroup]=[];}if($.inArray(codeToAdd,languagesByScriptGroup[langScriptGroup])===-1){languagesByScriptGroup[langScriptGroup].push(codeToAdd);}}return languagesByScriptGroup;};$.uls.data.getLanguagesByScriptGroupInRegions=function(regions){var language,i,scriptGroup,languagesByScriptGroupInRegions={};for(language in $.uls.data.languages){if($.uls.data.isRedirect(language)){continue;}for(i=0;i<
regions.length;i++){if($.inArray(regions[i],$.uls.data.getRegions(language))!==-1){scriptGroup=$.uls.data.getScriptGroupOfLanguage(language);if(languagesByScriptGroupInRegions[scriptGroup]===undefined){languagesByScriptGroupInRegions[scriptGroup]=[];}languagesByScriptGroupInRegions[scriptGroup].push(language);break;}}}return languagesByScriptGroupInRegions;};$.uls.data.getAllLanguagesByRegionAndScript=function(){var region,regionGroup,language,script,scriptGroup,regions,regionNum,allLanguagesByRegionAndScript={};for(region in $.uls.data.regiongroups){regionGroup=$.uls.data.regiongroups[region];if(allLanguagesByRegionAndScript[regionGroup]===undefined){allLanguagesByRegionAndScript[regionGroup]={};}allLanguagesByRegionAndScript[regionGroup][region]={};}for(language in $.uls.data.languages){if($.uls.data.isRedirect(language)){continue;}script=$.uls.data.getScript(language);scriptGroup=$.uls.data.getGroupOfScript(script);regions=$.uls.data.getRegions(language);for(regionNum=0;regionNum<
regions.length;regionNum++){region=regions[regionNum];regionGroup=$.uls.data.regiongroups[region];if(allLanguagesByRegionAndScript[regionGroup][region][scriptGroup]===undefined){allLanguagesByRegionAndScript[regionGroup][region][scriptGroup]={};}if(allLanguagesByRegionAndScript[regionGroup][region][scriptGroup][script]===undefined){allLanguagesByRegionAndScript[regionGroup][region][scriptGroup][script]=[];}allLanguagesByRegionAndScript[regionGroup][region][scriptGroup][script].push(language);}}return allLanguagesByRegionAndScript;};$.uls.data.getRegionsInGroup=function(groupNum){var region,regionsInGroup=[];for(region in $.uls.data.regiongroups){if($.uls.data.regiongroups[region]===groupNum){regionsInGroup.push(region);}}return regionsInGroup;};$.uls.data.getGroupOfScript=function(script){var scriptGroup;for(scriptGroup in $.uls.data.scriptgroups){if($.inArray(script,$.uls.data.scriptgroups[scriptGroup])!==-1){return scriptGroup;}}return'Other';};$.uls.data.getScriptGroupOfLanguage=
function(language){return $.uls.data.getGroupOfScript($.uls.data.getScript(language));};$.uls.data.sortByAutonym=function(a,b){var autonymA=$.uls.data.getAutonym(a)||a,autonymB=$.uls.data.getAutonym(b)||b;return(autonymA.toLowerCase()<autonymB.toLowerCase())?-1:1;};$.uls.data.isRtl=function(language){return $.inArray($.uls.data.getScript(language),$.uls.data.rtlscripts)!==-1;};$.uls.data.getDir=function(language){return $.uls.data.isRtl(language)?'rtl':'ltr';};$.uls.data.getLanguagesInTerritory=function(territory){return $.uls.data.territories[territory];};$.uls.data.addLanguage=function(code,options){if(options.target){$.uls.data.languages[code]=[options.target];}else{$.uls.data.languages[code]=[options.script,options.regions,options.autonym];}};$.uls.data.deleteLanguage=function(code){if($.uls.data.languages[code]){delete $.uls.data.languages[code];return true;}return false;};}(jQuery));;},{},{});mw.loader.implement("jquery.uls.grid",function(){},{"css":[
".grid *{-webkit-box-sizing:border-box;-moz-box-sizing:border-box;box-sizing:border-box} .grid .left{float:left}.grid .right{float:right}.grid .text-left{text-align:left}.grid .text-right{text-align:right}.grid .text-center{text-align:center}.grid .hide{display:none}.grid .highlight{background:#ffff99} .grid .row{width:100%;max-width:none;min-width:600px;margin:0 auto}.grid .row .row{width:auto;max-width:none;min-width:0;margin:0 -5px}.grid .row.collapse .column,.grid .row.collapse .columns{padding:0}.grid .row .row{width:auto;max-width:none;min-width:0;margin:0 -5px}.grid .row .row.collapse{margin:0}.grid .column,.grid .columns{float:left;min-height:1px;padding:0 5px;position:relative}.grid .column.centered,.grid .columns.centered{float:none;margin:0 auto}.grid .row .one{width:8.333%}.grid .row .two{width:16.667%}.grid .row .three{width:25%}.grid .row .four{width:33.333%}.grid .row .five{width:41.667%}.grid .row .six{width:50%}.grid .row .seven{width:58.333%}.grid .row .eight{width:66.667%}.grid .row .nine{width:75%}.grid .row .ten{width:83.333%}.grid .row .eleven{width:91.667%}.grid .row .twelve{width:100%}.grid .row .offset-by-one{margin-left:8.333%}.grid .row .offset-by-two{margin-left:16.667%}.grid .row .offset-by-three{margin-left:25%}.grid .row .offset-by-four{margin-left:33.333%}.grid .row .offset-by-five{margin-left:41.667%}.grid .row .offset-by-six{margin-left:50%}.grid .row .offset-by-seven{margin-left:58.333%}.grid .row .offset-by-eight{margin-left:66.667%}.grid .row .offset-by-nine{margin-left:75%}.grid .row .offset-by-ten{margin-left:83.333%}.grid .push-two{left:16.667%}.grid .pull-two{right:16.667%}.grid .push-three{left:25%}.grid .pull-three{right:25%}.grid .push-four{left:33.333%}.grid .pull-four{right:33.333%}.grid .push-five{left:41.667%}.grid .pull-five{right:41.667%}.grid .push-six{left:50%}.grid .pull-six{right:50%}.grid .push-seven{left:58.333%}.grid .pull-seven{right:58.333%}.grid .push-eight{left:66.667%}.grid .pull-eight{right:66.667%}.grid .push-nine{left:75%}.grid .pull-nine{right:75%}.grid .push-ten{left:83.333%}.grid .pull-ten{right:83.333%} .grid .row{*zoom:1}.grid .row:before,.grid .row:after{content:\"\";display:table}.grid .row:after{clear:both}  .grid .block-grid{display:block;overflow:hidden;padding:0}.grid .block-grid \u003E li{display:block;height:auto;float:left}.grid .block-grid.two-up{margin:0 -15px}.grid .block-grid.two-up \u003E li{width:50%;padding:0 15px 15px} .grid .block-grid.three-up{margin:0 -12px}.grid .block-grid.three-up \u003E li{width:33.33%;padding:0 12px 12px} .grid .block-grid.four-up{margin:0 -10px}.grid .block-grid.four-up \u003E li{width:25%;padding:0 10px 10px} .grid .block-grid.five-up{margin:0 -8px}.grid .block-grid.five-up \u003E li{width:20%;padding:0 8px 8px}\n/* cache key: enwiki:resourceloader:filter:minify-css:7:09eb7fe541cbcdc79775eb1a3ef4ceba */"
]},{});
/* cache key: enwiki:resourceloader:filter:minify-js:7:b4f755ac7b82f44c65022b532d8ad7bb */